<?php


// Evitar acceso directo
if (!defined('ABSPATH')) exit;




// Shortcode para registro de entrada/salida con geolocalización
function registro_entrada_salida_shortcode() {
// Cargar estilos desde la carpeta CSS junto a este archivo
if (!wp_style_is('mi-plugin-css', 'enqueued')) {
    wp_enqueue_style(
        'mi-plugin-css',
        plugin_dir_url(__FILE__) . '../css/estilos.css',
        array(),
        time()
    );
}
 ob_start();
    ?>

    <form id="registro-form" class="pure-form pure-form-stacked">
        <fieldset>
        <div style="display: flex; flex-direction: column; align-items: center; text-align: center;">
    <label for="dni">Introduce tu código:</label>
    <small style="color: gray; display: block; margin-top: 2px;">DNI sin la letra</small>
<input
  type="text"
  name="dni"
  id="dni"
  inputmode="numeric"
  pattern="[0-9]{6,8}"
  minlength="6"
  maxlength="8"
  required
  style="width: 200px; text-align: center;"
  placeholder="6-8 dígitos"
/>

    <!-- Enlace para limpiar -->
    <span id="limpiarDni" 
          style="color: #aaa; font-size: 12px; margin-top: 5px; cursor: pointer; text-decoration: underline;">
        Limpiar
    </span>
</div>


            <br>
<div style="display: flex; justify-content: center; gap: 20px; margin-top: 10px;">
    <!-- Botón de Entrada (Principal) -->
    <button type="button" id="btnEntrada" class="pure-button pure-button-primary"
            style="font-size: 20px; padding: 15px 40px; width: 180px; height: 60px;">
        Entrada
    </button>

    <!-- Botón de Salida (Peligro) -->
    <button type="button" id="btnSalida" class="pure-button pure-button-danger"
            style="font-size: 20px; padding: 15px 40px; width: 180px; height: 60px;">
        Salida
    </button>
</div>

            <br>
            <div style="display: flex; gap: 10px; justify-content: center; align-items: center;">
               
                <div style="display: flex; gap: 20px; justify-content: center;">
                <br>
    <div style="display: flex; flex-direction: column; align-items: center; text-align: center;">
 <br>
        <label for="latitud">Latitud:</label>
        <input type="text" name="latitud" id="latitud" readonly required style="text-align: center; width: 170px;">
    </div>
    <div style="display: flex; flex-direction: column; align-items: center; text-align: center;">
    <br>
        <label for="longitud">Longitud:</label>
        <input type="text" name="longitud" id="longitud" readonly required style="text-align: center; width: 170px;">
    </div>
</div>

            </div>

            <br>

            
        </fieldset>
    </form>

    <p id="mensaje"></p>

    <div id="ubicacion-error" style="display: none; text-align: center; margin-top: 10px;">
    <p style="color: red;">
        <img src="https://cdn-icons-png.flaticon.com/512/61/61183.png" alt="Ubicación bloqueada" width="20" style="vertical-align: middle; margin-right: 5px;">
        La ubicación está bloqueada. Por favor, actívala para registrar tu entrada o salida.
    </p>
    <button id="retryUbicacion" class="pure-button pure-button-secondary">Intentar otra vez</button>
</div>


    <script>
document.addEventListener("DOMContentLoaded", function() {
    obtenerUbicacion();

    document.getElementById("btnEntrada").addEventListener("click", function() {
        validarRegistro("entrada");
    });

    document.getElementById("btnSalida").addEventListener("click", function() {
        validarRegistro("salida");
    });

        // Botón "Limpiar" debajo del DNI
    document.getElementById("limpiarDni").addEventListener("click", function() {
        document.getElementById("dni").value = "";
        document.getElementById("dni").focus();
        document.getElementById("mensaje").innerHTML = ""; // opcional, limpia mensajes
    });


                    function obtenerUbicacion() {
                        // Limpiamos campos por si quedaron valores anteriores
                        document.getElementById('latitud').value = "";
                        document.getElementById('longitud').value = "";

                        if (navigator.geolocation) {
                            navigator.geolocation.getCurrentPosition(
                                function (position) {
                                    document.getElementById('latitud').value = position.coords.latitude.toFixed(8);
                                    document.getElementById('longitud').value = position.coords.longitude.toFixed(8);
                                    document.getElementById('ubicacion-error').style.display = "none";
                                },
                                function (error) {
                                    console.warn("Error de geolocalización:", error.message);
                                    
                                    let mensajeError = "Error al obtener la ubicación.";

                                    switch (error.code) {
                                        case error.PERMISSION_DENIED:
                                            mensajeError = "Has bloqueado la ubicación. Si quieres activar el fichaje, ve a la configuración del navegador y permite el acceso.";
                                            break;
                                        case error.POSITION_UNAVAILABLE:
                                            mensajeError = "La ubicación no está disponible.";
                                            break;
                                        case error.TIMEOUT:
                                            mensajeError = "Tiempo de espera excedido al intentar obtener la ubicación.";
                                            break;
                                    }

                                    document.getElementById('ubicacion-error').style.display = "block";
                                    document.getElementById('ubicacion-error').querySelector('p').innerHTML = `
                                        <img src="https://cdn-icons-png.flaticon.com/512/61/61183.png" alt="Ubicación bloqueada" width="20" style="vertical-align: middle; margin-right: 5px;">
                                        ${mensajeError}
                                    `;
                                }
                            );
                        } else {
                            alert("La geolocalización no está soportada en este navegador.");
                        }
                    }




    function validarRegistro(tipo) {
        let dni = document.getElementById("dni").value.trim();
        if (!dni) {
document.getElementById("mensaje").innerHTML = '<p style="color: red; background:#ffecec; border:2px solid red; padding:10px; font-size:18px; font-weight:bold; text-align:center;">⚠️ Error inesperado en el servidor.</p>';
    return;
}


        fetch('<?php echo admin_url('admin-ajax.php'); ?>', {
            method: 'POST',
            headers: { 'Content-Type': 'application/x-www-form-urlencoded' },
            body: `action=validar_fichaje&dni=${dni}&tipo=${tipo}`
        })
        .then(response => response.json())
.then(data => {
    // Soporta tanto {mensaje,...} como {success:true, data:{mensaje,...}}
    const payload = (data && data.data) ? data.data : data;

    const msg = (payload && payload.mensaje) ? payload.mensaje : '';
    document.getElementById("mensaje").innerHTML = msg;

    if (payload && payload.registro_permitido) {
        registrar(tipo);
    }
})

        .catch(error => {
            console.error("Error al procesar la respuesta JSON:", error);
            document.getElementById("mensaje").innerHTML = "<p style='color: red; text-align: center;'>Error inesperado en el servidor.</p>";
        });
    }

    function registrar(tipo) {
        let dni = document.getElementById("dni").value.trim();
        let latitud = document.getElementById("latitud").value;
        let longitud = document.getElementById("longitud").value;

       if (!latitud || !longitud) {
    const continuar = confirm(
        "⚠️ Estás a punto de fichar sin geolocalización.\n\n" +
        "Si esto es un error, revisa los permisos del navegador:\n\n" +
        "🔹 Chrome: haz clic en el icono del candado (🔒) junto a la URL y permite la ubicación.\n" +
        "🔹 Firefox: Ajustes > Privacidad y Seguridad > Permisos > Ubicación.\n" +
        "🔹 Safari: Preferencias > Seguridad > Permitir servicios de localización.\n\n" +
        "¿Quieres continuar de todas formas?"
    );

    if (!continuar) {
        return; // el usuario canceló
    }
}




        fetch('<?php echo admin_url('admin-ajax.php'); ?>', {
            method: 'POST',
            headers: { 'Content-Type': 'application/x-www-form-urlencoded' },
            body: `action=registrar_fichaje&dni=${dni}&tipo=${tipo}&latitud=${latitud}&longitud=${longitud}`
        })
        .then(response => response.json())
.then(data => {
    const payload = (data && data.data) ? data.data : data;
    const msg = (payload && payload.mensaje) ? payload.mensaje : '';
    document.getElementById("mensaje").innerHTML = msg;

    document.getElementById("dni").value = "";
    setTimeout(() => { location.reload(); }, 1500);
})

        .catch(error => {
            console.error("Error en registro de fichaje:", error);
document.getElementById("mensaje").innerHTML = '<p style="color: red; background:#ffecec; border:2px solid red; padding:10px; font-size:18px; font-weight:bold; text-align:center;">❌ Error al registrar el fichaje.</p>';
        });
    }
});




///////////COMPROBAR SI TIENE INSTALADO AL APP


// Botón flotante para instalar la app (solo en /externo y si es instalable)
let deferredPrompt;

window.addEventListener('beforeinstallprompt', (e) => {
    const enExterno = window.location.pathname.includes('/externo');
    if (!enExterno) return;

    e.preventDefault();
    deferredPrompt = e;

    const installBtn = document.createElement('button');
    installBtn.innerText = '📲 Instalar App';
    installBtn.style.position = 'fixed';
    installBtn.style.bottom = '20px';
    installBtn.style.right = '20px';
    installBtn.style.zIndex = '10000';
    installBtn.style.padding = '12px 20px';
    installBtn.style.background = '#0073aa';
    installBtn.style.color = '#fff';
    installBtn.style.border = 'none';
    installBtn.style.borderRadius = '5px';
    installBtn.style.boxShadow = '0 2px 6px rgba(0,0,0,0.2)';
    installBtn.style.cursor = 'pointer';
    installBtn.style.fontSize = '16px';

    document.body.appendChild(installBtn);

    installBtn.addEventListener('click', () => {
        installBtn.remove();
        deferredPrompt.prompt();

        deferredPrompt.userChoice.then((choiceResult) => {
            if (choiceResult.outcome === 'accepted') {
                console.log('✅ Usuario aceptó la instalación');
            } else {
                console.log('❌ Usuario rechazó la instalación');
            }
            deferredPrompt = null;
        });
    });
});




</script>


    <style>
        .pure-button-secondary {
            background: #555;
            color: white;
        }
        input[readonly] {
            background: #f4f4f4;
            border: 1px solid #ccc;
        }
        div > input {
            width: 120px;
        }
    </style>

    <?php
    return ob_get_clean();
}
add_shortcode('registro_entrada_salida', 'registro_entrada_salida_shortcode');

// AJAX para validar si se puede fichar
add_action('wp_ajax_validar_fichaje', 'validar_fichaje');
add_action('wp_ajax_nopriv_validar_fichaje', 'validar_fichaje');

function validar_fichaje() {
    global $wpdb;
    $dni  = sanitize_text_field($_POST['dni']);
    $tipo = sanitize_text_field($_POST['tipo']);

    // Traemos también user_cif_id (empresa_id)
    $usuario = $wpdb->get_row($wpdb->prepare(
        "SELECT ID, user_cif, user_cif_id
         FROM {$wpdb->prefix}users
         WHERE TRIM(user_dni) = %s",
        $dni
    ));

   if (!$usuario) {
    wp_send_json([
        'registro_permitido' => false,
        'mensaje' => '<p style="color: red; background:#ffecec; border:2px solid red; padding:10px; font-size:18px; font-weight:bold; text-align:center;">❌ DNI no encontrado en la base de datos.</p>'
    ]);
}

    $user_id     = (int) $usuario->ID;
    $cif_usuario = (string) $usuario->user_cif;

    // Comprobamos si hay entrada pendiente (por usuario + cif para mantener compatibilidad)
    $entrada_pendiente = $wpdb->get_row($wpdb->prepare(
        "SELECT id
         FROM {$wpdb->prefix}registro_horario
         WHERE user_id = %d AND cif_usuario = %s AND salida IS NULL
         ORDER BY entrada DESC LIMIT 1",
        $user_id, $cif_usuario
    ));

  if ($tipo === "entrada" && $entrada_pendiente) {
    wp_send_json([
        'registro_permitido' => false,
        'mensaje' => '<p style="color: red; background:#ffecec; border:2px solid red; padding:10px; font-size:18px; font-weight:bold; text-align:center;">❌ Ya tienes una entrada pendiente, no puedes fichar otra hasta registrar la salida.</p>'
    ]);
} elseif ($tipo === "salida" && !$entrada_pendiente) {
    wp_send_json([
        'registro_permitido' => false,
        'mensaje' => '<p style="color: red; background:#ffecec; border:2px solid red; padding:10px; font-size:18px; font-weight:bold; text-align:center;">❌ No tienes ninguna entrada pendiente, no puedes registrar una salida.</p>'
    ]);
} else {
    wp_send_json([
        'registro_permitido' => true,
        'mensaje' => '<p style="color: green; background:#e6ffed; border:2px solid green; padding:10px; font-size:18px; font-weight:bold; text-align:center;">✅ Registro permitido, procesando...</p>'
    ]);
}

}

// AJAX para registrar entrada o salida

function registrar_fichaje() {
    global $wpdb;

    $dni      = sanitize_text_field($_POST['dni']);
    $tipo     = sanitize_text_field($_POST['tipo']);
    $latitud  = (isset($_POST['latitud'])  && $_POST['latitud']  !== '') ? floatval($_POST['latitud'])  : null;
    $longitud = (isset($_POST['longitud']) && $_POST['longitud'] !== '') ? floatval($_POST['longitud']) : null;

    $timestamp_actual = current_time('mysql');

    // Traemos también user_cif_id (id de la empresa)
    $usuario = $wpdb->get_row($wpdb->prepare(
        "SELECT ID, user_cif, user_cif_id
         FROM {$wpdb->prefix}users
         WHERE TRIM(user_dni) = %s",
        $dni
    ));

    if (!$usuario) {
    wp_send_json([
        'mensaje' => '<p style="color: red; background:#ffecec; border:2px solid red; padding:10px; font-size:18px; font-weight:bold; text-align:center;">❌ Error: Usuario no encontrado.</p>'
    ]);
}


    $user_id  = (int) $usuario->ID;
    $user_cif = (string) $usuario->user_cif;
    $cif_id   = !empty($usuario->user_cif_id) ? (int)$usuario->user_cif_id : null;

    // Fallback: si no hay user_cif_id, intentamos obtenerlo por el CIF del usuario
    if (!$cif_id && $user_cif !== '') {
        $cif_id = (int) $wpdb->get_var($wpdb->prepare(
            "SELECT id FROM {$wpdb->prefix}empresas WHERE user_cif = %s LIMIT 1",
            $user_cif
        ));
    }

    if ($tipo === 'entrada') {
        // Guardamos cif_id junto con el registro
        $wpdb->insert("{$wpdb->prefix}registro_horario", [
            'user_id'          => $user_id,
            'cif_usuario'      => $user_cif,
            'cif_id'           => $cif_id ?: null, // NULL si no se encuentra
            'entrada'          => $timestamp_actual,
            'entradaR'         => $timestamp_actual,
            'latitud_entrada'  => $latitud,
            'longitud_entrada' => $longitud
        ]);

wp_send_json([
    'mensaje' => '<p style="color: green; background:#e6ffed; border:2px solid green; padding:10px; font-size:18px; font-weight:bold; text-align:center;">✅ Entrada registrada correctamente.</p>'
]);

    } else {
        // Buscar la última entrada sin salida
        $entrada_pendiente = $wpdb->get_row($wpdb->prepare(
            "SELECT id, entradaR, cif_id
             FROM {$wpdb->prefix}registro_horario
             WHERE user_id = %d AND cif_usuario = %s AND salida IS NULL
             ORDER BY entrada DESC LIMIT 1",
            $user_id, $user_cif
        ));

        if (!$entrada_pendiente) {
    wp_send_json([
        'mensaje' => '<p style="color: red; background:#ffecec; border:2px solid red; padding:10px; font-size:18px; font-weight:bold; text-align:center;">❌ No hay una entrada pendiente para registrar la salida.</p>'
    ]);
}


        // Calcular tiempo total
        $entrada = strtotime($entrada_pendiente->entradaR);
        $salida  = strtotime($timestamp_actual);
        $diff    = max(0, $salida - $entrada);
        $tiempo_total = sprintf('%02d:%02d:%02d', floor($diff/3600), floor(($diff%3600)/60), $diff%60);

        // Si el registro no tenía cif_id, lo rellenamos ahora
        $cif_id_final = $entrada_pendiente->cif_id ?: ($cif_id ?: null);

        // Actualizamos salida y guardamos cif_id
        $wpdb->update("{$wpdb->prefix}registro_horario", [
            'salida'           => $timestamp_actual,
            'salidaR'          => $timestamp_actual,
            'latitud_salida'   => $latitud,
            'longitud_salida'  => $longitud,
            'tiempo_total'     => $tiempo_total,
            'tiempo_totalR'    => $tiempo_total,
            'cif_id'           => $cif_id_final
        ], [
            'id' => (int)$entrada_pendiente->id
        ]);

        // Gamificación como ya tenías
        calcular_puntos_gamificacion($user_id, (int)$entrada_pendiente->id);

wp_send_json([
    'mensaje' => '<p style="color: green; background:#e6ffed; border:2px solid green; padding:10px; font-size:18px; font-weight:bold; text-align:center;">✅ Salida registrada correctamente.</p>'
]);
    }
}



add_action('wp_ajax_validar_fichaje', 'validar_fichaje');
add_action('wp_ajax_nopriv_validar_fichaje', 'validar_fichaje');
add_action('wp_ajax_registrar_fichaje', 'registrar_fichaje');
add_action('wp_ajax_nopriv_registrar_fichaje', 'registrar_fichaje');




