<?php
// Evitar acceso directo
if (!defined('ABSPATH')) {
    exit;
}

// SHORTCODE: [nuevo_gestor_front]
add_shortcode('nuevo_gestor_front', 'mostrar_formulario_gestor_front');

function mostrar_formulario_gestor_front() {
    if (!current_user_can('administrator')) {
        return '<p style="color:red; text-align:center;">Este formulario solo está disponible para administradores.</p>';
    }

    ob_start();
    global $wpdb;
    $mensaje = '';
    $tabla_usuarios = $wpdb->prefix . 'users';

    if (isset($_POST['guardar_gestor'])) {
        $user_login = sanitize_text_field($_POST['user_login']);
        $user_email = sanitize_email($_POST['user_email']);
        $user_dni   = sanitize_text_field($_POST['user_dni']);
        $user_cif   = sanitize_text_field($_POST['user_cif']);
        $user_gamificacion = isset($_POST['user_gamificacion']) ? 1 : 0;

        if (empty($user_email) || empty($user_login)) {
            $mensaje = '<p style="color:red;">El correo y el nombre de usuario son obligatorios.</p>';
        } else {
            $password = sanitize_text_field($_POST['user_pass'] ?? '');

if (empty($password)) {
    // Contraseña simple y legible (8 caracteres alfanuméricos)
    $password = substr(md5(uniqid(rand(), true)), 0, 8);
}

$new_user_id = wp_insert_user([
    'user_login' => $user_login,
    'user_email' => $user_email,
    'user_pass'  => $password,
    'role'       => 'gestor'
]);


            if (!is_wp_error($new_user_id)) {
                $wpdb->update(
                    $tabla_usuarios,
                    [
                        'user_dni' => $user_dni,
                        'user_cif' => $user_cif,
                        'user_gamificacion' => $user_gamificacion,
                        'user_rol' => 'Gestor'
                    ],
                    ['ID' => $new_user_id]
                );

                $template_path = plugin_dir_path(dirname(__FILE__)) . 'templates/email-nuevo-gestor.html';

                if (file_exists($template_path)) {
                    $email_body = file_get_contents($template_path);
                    $email_body = str_replace(
                        ['[user_login]', '[user_email]', '[password]'],
                        [$user_login, $user_email, $password],
                        $email_body
                    );

                    $headers = [
                        'Content-Type: text/html; charset=UTF-8',
                        'From: E-Digitiall <no-reply@educasede.com>'
                    ];

                    $enviado = wp_mail($user_email, 'Bienvenido a E-Digitiall', $email_body, $headers);
                    error_log($enviado ? "✅ Email de nuevo gestor enviado a $user_email" : "❌ Falló el envío del email a $user_email");
                } else {
                    error_log("❌ No se encontró la plantilla de email en: $template_path");
                }

                $mensaje = '<p style="color:green;">✅ Gestor creado correctamente.</p>';
            } else {
                $mensaje = '<p style="color:red;">❌ Error al crear gestor: ' . $new_user_id->get_error_message() . '</p>';
            }
        }
    }

    ?>

    <div class="nuevo-gestor-form" style="max-width: 600px; margin: auto;">
        <h2>Crear Nuevo Gestor</h2>
        <?php echo $mensaje; ?>
        <form method="post" class="pure-form pure-form-stacked">
            <label>Nombre de Usuario:
                <input type="text" name="user_login" required>
            </label>
            <label>Correo Electrónico:
                <input type="email" name="user_email" required>
            </label>
            <label>DNI:
                <input type="text" name="user_dni">
            </label>
            <label>CIF:
                <input type="text" name="user_cif">
            </label>
            <label>Gamificación:
                <input type="checkbox" name="user_gamificacion" value="1"> Activar
            </label>
            <label>Contraseña (opcional):
    <input type="text" name="user_pass" placeholder="Dejar vacío para generar automaticamente">
</label>

            <br>
            <input type="submit" name="guardar_gestor" class="pure-button pure-button-primary" value="Crear Gestor">
        </form>
    </div>

    <?php
    return ob_get_clean();
}
