<?php


if (!defined('ABSPATH')) {
    exit;
}

add_shortcode('listar_trabajadores', 'mostrar_trabajadores');

function mostrar_trabajadores() {
    if (!is_user_logged_in()) {
        return '<p class="pure-alert" style="text-align: center;">No has iniciado sesión.</p>';
    }

    global $wpdb;


/////////////////// PARA BORRAR 

if (!function_exists('wp_mail')) {
    require_once ABSPATH . WPINC . '/pluggable.php';
}
error_log("🧪 Probando el log de errores manual");


/////////////////////////////////

   $current_user = wp_get_current_user();
$usuario_actual = $wpdb->get_row($wpdb->prepare("SELECT * FROM mnkt_users WHERE user_email = %s", $current_user->user_email));

if (!$usuario_actual) {
    return '<p>No se encontró un usuario válido.</p>';
}

if ($usuario_actual->user_rol !== 'Gestor' || $usuario_actual->user_estado !== 'Activado') {
    return '<p class="pure-alert" style="text-align: center;">No tienes permisos para acceder a esta funcionalidad.</p>';
}

// Empresas del gestor vía asociaciones (NO desde users)
$empresas = $wpdb->get_results($wpdb->prepare("
    SELECT DISTINCT e.id, e.user_cif, e.razon_social
    FROM {$wpdb->prefix}empresas_usuarios eu
    JOIN {$wpdb->prefix}empresas e ON e.id = eu.empresa_id
    WHERE eu.user_id = %d
      AND eu.rol_en_empresa = 'Gestor'
      AND eu.estado = 'Activado'
    ORDER BY e.razon_social ASC, e.user_cif ASC
", $usuario_actual->ID));

if (!$empresas) {
    return '<p class="pure-alert" style="text-align:center;">No tienes ninguna empresa asociada como Gestor.</p>';
}

// CIFs derivados de las asociaciones (para el <select name="cif">)
$cifs = array_map(fn($e) => $e->user_cif, $empresas);

// Seleccionar CIF activo (por GET o el primero)
if (isset($_GET['cif']) && in_array($_GET['cif'], $cifs, true)) {
    $_SESSION['cif_activo'] = sanitize_text_field($_GET['cif']);
}
$user_cif = $_SESSION['cif_activo'] ?? ($cifs[0] ?? null);

if (!$user_cif) {
    return '<p class="pure-alert">No se pudo determinar un CIF activo válido.</p>';
}





    // Activar o desactivar trabajador
    if (isset($_GET['toggle'])) {
        $id = intval($_GET['toggle']);
        $estado_actual = $wpdb->get_var($wpdb->prepare("SELECT user_estado FROM mnkt_users WHERE ID = %d", $id));
        $nuevo_estado = ($estado_actual === 'Activado') ? 'Desactivado' : 'Activado';
        $wpdb->update('mnkt_users', ['user_estado' => $nuevo_estado], ['ID' => $id]);
        if (!defined('DOING_AJAX') || !DOING_AJAX) {            wp_safe_redirect(remove_query_arg('toggle'));
            exit;
        }

    }

// Reenviar enlace de recuperación de contraseña
if (isset($_GET['reenviar']) && is_numeric($_GET['reenviar'])) {
    $trabajador = get_userdata(intval($_GET['reenviar']));
    if ($trabajador && $trabajador->user_email) {
        retrieve_password($trabajador->user_login);
        echo '<p class="pure-alert pure-alert-success" style="margin-top: 10px;">🔑 Enlace de recuperación enviado a ' . esc_html($trabajador->user_email) . '</p>';
    }
}




    // Editar trabajador
    if (isset($_POST['editar_trabajador'])) {
        $id = intval($_POST['trabajador_id']);
        $nombre = sanitize_text_field($_POST['nombre']);
        $email = sanitize_email($_POST['email']);
        $dni = sanitize_text_field($_POST['dni']);
        $existe_email = $wpdb->get_var($wpdb->prepare("SELECT COUNT(*) FROM mnkt_users WHERE user_email = %s AND ID != %d", $email, $id));
        if ($existe_email > 0) {
            echo '<p style="color:red;">Error: El email ya está en uso.</p>';
        } else {
            $wpdb->update('mnkt_users', [
                'display_name' => $nombre,
                'user_email' => $email,
                'user_dni' => $dni
            ], ['ID' => $id]);
                    if (!defined('DOING_AJAX') || !DOING_AJAX) {
            wp_safe_redirect($_SERVER['REQUEST_URI']);
            exit;
        }

        }
    }

   
// Filtro de estado (para la tabla y el selector)
$estado_filtro = isset($_GET['estado']) ? sanitize_text_field($_GET['estado']) : 'Activado';
$condicion_estado = ($estado_filtro === 'todos')
    ? ''
    : $wpdb->prepare(" AND user_estado = %s", $estado_filtro);

// Orden: 'fecha' (por defecto) o 'nombre'
$orden = isset($_GET['orden']) ? sanitize_text_field($_GET['orden']) : 'fecha';
$order_by_sql = ($orden === 'nombre')
    ? " ORDER BY display_name ASC"
    : " ORDER BY user_registered DESC, ID DESC";


  $trabajadores = $wpdb->get_results(
    $wpdb->prepare("SELECT * FROM mnkt_users 
                    WHERE user_cif = %s 
                      AND user_rol = 'Trabajador' 
                      $condicion_estado
                    $order_by_sql", 
                    $user_cif)
);


    ob_start();
    ?>

    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/pure/2.0.6/pure-min.css">

<h3>Listar Trabajadores</h3>

<form method="get" class="pure-form" style="display: flex; gap: 12px; align-items: center; flex-wrap: wrap; margin-bottom: 15px;">

    <?php if (count($cifs) > 1): ?>
        <label>Empresa:
            <select name="cif" onchange="this.form.submit()">
                <?php foreach ($empresas as $e): ?>
                    <option value="<?php echo esc_attr($e->user_cif); ?>" <?php selected($user_cif, $e->user_cif); ?>>
                        <?php echo esc_html($e->user_cif . ' — ' . ($e->razon_social ?: 'Sin razón social')); ?>
                    </option>
                <?php endforeach; ?>
            </select>
        </label>
    <?php else: ?>
        <!-- Si solo hay 1 empresa, mantenemos el cif en el GET con un hidden -->
        <input type="hidden" name="cif" value="<?php echo esc_attr($user_cif); ?>">
    <?php endif; ?>

    <label>Estado:
        <select name="estado" onchange="this.form.submit()">
            <option value="todos" <?php selected($estado_filtro, 'todos'); ?>>Todos</option>
            <option value="Activado" <?php selected($estado_filtro, 'Activado'); ?>>Activados</option>
            <option value="Desactivado" <?php selected($estado_filtro, 'Desactivado'); ?>>Desactivados</option>
        </select>
    </label>

    <label>Ordenar por:
        <select name="orden" onchange="this.form.submit()">
            <option value="fecha" <?php selected($orden, 'fecha'); ?>>Fecha (recientes primero)</option>
            <option value="nombre" <?php selected($orden, 'nombre'); ?>>Nombre (A → Z)</option>
        </select>
    </label>

</form>



    <table class="pure-table pure-table-bordered">
        <thead>
    <tr>
        <th>Nombre</th>
        <th>Email</th>
        <th>DNI</th>
        <?php if ($estado_filtro === 'todos') : ?>
            <th>Estado</th>
        <?php endif; ?>
        <th>Acciones</th>
    </tr>
</thead>

     <tbody>
    <?php foreach ($trabajadores as $trabajador) : ?>
        <tr>
            <td><?php echo esc_html($trabajador->display_name); ?></td>
            <td><?php echo esc_html($trabajador->user_email); ?></td>
            <td><?php echo esc_html($trabajador->user_dni); ?></td>
            
            <?php if ($estado_filtro === 'todos') : ?>
<td>
    <?php
        $estado = esc_html($trabajador->user_estado);
        $color = ($estado === 'Activado') ? 'green' : 'red';
        echo "<span style='color: $color; font-weight: bold;'>$estado</span>";
    ?>
</td>
            <?php endif; ?>

            <td>
                    <a href="?edit=<?php echo $trabajador->ID; ?>" title="Editar trabajador/a">✏️</a> |
                    <a href="?toggle=<?php echo $trabajador->ID; ?>" 
                        onclick="return confirm('¿Seguro que deseas cambiar el estado de este trabajador?');"
                        title="<?php echo ($trabajador->user_estado === 'Activado') ? 'Desactivar trabajador' : 'Activar trabajador'; ?>">
                            <?php echo ($trabajador->user_estado === 'Activado') ? '⛔' : '✅'; ?>
                    </a> |
                <a href="?reenviar=<?php echo $trabajador->ID; ?>" title="Recuperar contraseña">🔑</a>
            </td>
        </tr>
    <?php endforeach; ?>
</tbody>

    </table>

    <?php if (isset($_GET['edit'])): 
        $id = intval($_GET['edit']);
        $trabajador = $wpdb->get_row($wpdb->prepare("SELECT * FROM mnkt_users WHERE ID = %d", $id));
    ?>
    <h3>Editar Trabajador</h3>
    <form method="post" class="pure-form pure-form-stacked">
        <input type="hidden" name="trabajador_id" value="<?php echo $trabajador->ID; ?>">
        <label>Nombre: <input type="text" name="nombre" value="<?php echo esc_attr($trabajador->display_name); ?>" required></label>
        <label>Email: <input type="email" name="email" value="<?php echo esc_attr($trabajador->user_email); ?>" required></label>
        <label>Nº DNI (sin la letra): <input type="text" name="dni" value="<?php echo esc_attr($trabajador->user_dni); ?>" pattern="[0-9]{6,8}" required></label>
        <input type="submit" name="editar_trabajador" class="pure-button pure-button-primary" value="Actualizar">
    </form>
    <?php endif; ?>

    <br><br>

    
<br>
<br>



    <?php
    return ob_get_clean();
}
//////////////////////////////SHORTCODE PARA SUBIR TRABAJADORES EN CSV


add_shortcode('subir_trabajadores_csv', 'formulario_subir_trabajadores_csv');

function formulario_subir_trabajadores_csv() {
    if (!is_user_logged_in()) {
        return '<p class="pure-alert" style="text-align: center;">No has iniciado sesión.</p>';
    }

    global $wpdb;

    $tabla_empresas           = $wpdb->prefix . 'empresas';
    $tabla_empresas_usuarios  = $wpdb->prefix . 'empresas_usuarios';

    $current_user   = wp_get_current_user();
    $usuario_actual = $wpdb->get_row($wpdb->prepare("SELECT * FROM mnkt_users WHERE user_email = %s", $current_user->user_email));

    if (!$usuario_actual || $usuario_actual->user_rol !== 'Gestor' || $usuario_actual->user_estado !== 'Activado') {
        return '<p class="pure-alert" style="text-align: center;">No tienes permisos para acceder a esta funcionalidad.</p>';
    }

    // 1) Empresas del gestor vía asociaciones (NO desde users)
    $empresas = $wpdb->get_results($wpdb->prepare("
        SELECT DISTINCT e.id, e.user_cif, e.razon_social
        FROM {$tabla_empresas_usuarios} eu
        JOIN {$tabla_empresas} e ON e.id = eu.empresa_id
        WHERE eu.user_id = %d
          AND eu.rol_en_empresa = 'Gestor'
          AND eu.estado = 'Activado'
        ORDER BY e.razon_social ASC, e.user_cif ASC
    ", $usuario_actual->ID));

    if (!$empresas) {
        return '<p class="pure-alert" style="text-align:center;">No tienes ninguna empresa asociada como Gestor.</p>';
    }

    // 2) Resolver empresa activa desde el selector superior (GET)
    // Soporta ?empresa_id=... o ?cif=...
    $emp_index_by_id  = [];
    $emp_index_by_cif = [];
    foreach ($empresas as $e) {
        $emp_index_by_id[(int)$e->id]   = $e;
        $emp_index_by_cif[$e->user_cif] = $e;
    }

    $empresa_id = 0;
    if (isset($_GET['empresa_id']) && ctype_digit($_GET['empresa_id'])) {
        $tmp = (int) $_GET['empresa_id'];
        if (isset($emp_index_by_id[$tmp])) $empresa_id = $tmp;
    }
    if (!$empresa_id && isset($_GET['cif'])) {
        $cif = sanitize_text_field($_GET['cif']);
        if (isset($emp_index_by_cif[$cif])) $empresa_id = (int)$emp_index_by_cif[$cif]->id;
    }
    if (!$empresa_id) {
        $empresa_id = (int)$empresas[0]->id; // fallback a la primera
    }

    $user_cif          = $emp_index_by_id[$empresa_id]->user_cif;
    $empresa_label_txt = ($emp_index_by_id[$empresa_id]->razon_social ?: 'Sin razón social') . ' — ' . $user_cif;

    $user_gamificacion = $usuario_actual->user_gamificacion;
    $resultado_html    = '';

    // 3) Procesar subida CSV
    if (isset($_POST['cargar_csv_trabajadores']) && !empty($_FILES['archivo_csv']['tmp_name'])) {
        // Cerrar con la empresa enviada por el form (hidden), validando que es del gestor
        if (isset($_POST['empresa_id']) && ctype_digit($_POST['empresa_id'])) {
            $posted_id = (int) $_POST['empresa_id'];
            if (isset($emp_index_by_id[$posted_id])) {
                $empresa_id = $posted_id;
                $user_cif   = $emp_index_by_id[$empresa_id]->user_cif;
                $empresa_label_txt = ($emp_index_by_id[$empresa_id]->razon_social ?: 'Sin razón social') . ' — ' . $user_cif;
            } else {
                return '<div class="pure-alert" style="color:#b00;">❌ Empresa no válida para este gestor.</div>';
            }
        }

        $file            = $_FILES['archivo_csv']['tmp_name'];
        $insertados      = 0;
        $linea           = 0;
        $errores         = [];
        $insertados_info = [];

        if (($handle = fopen($file, 'r')) !== false) {
            while (($data = fgetcsv($handle, 1000, ',')) !== false) {
                $linea++;

                // Cabecera: nombre,dni,email
                if ($linea === 1) {
                    $cabeceras = array_map('strtolower', array_map('trim', $data));
                    if ($cabeceras !== ['nombre', 'dni', 'email']) {
                        $errores[] = "❌ Línea 1: El archivo debe tener las columnas en orden exacto: nombre, dni, email.";
                        break;
                    }
                    continue;
                }

                list($nombre, $dni, $email) = array_map('trim', $data);

                // Validaciones
                if (empty($nombre) || empty($dni) || empty($email)) {
                    $errores[] = "❌ Línea $linea: Faltan datos.";
                    continue;
                }
                if (!filter_var($email, FILTER_VALIDATE_EMAIL)) {
                    $errores[] = "❌ Línea $linea: Email inválido.";
                    continue;
                }

                $dni_numerico = preg_replace('/\D+/', '', $dni);
                if (!preg_match('/^[0-9]{6,8}$/', $dni_numerico)) {
                    $errores[] = "❌ Línea $linea: DNI inválido (solo 6-8 dígitos).";
                    continue;
                }

                // Email duplicado
                $existe = $wpdb->get_var($wpdb->prepare(
                    "SELECT COUNT(*) FROM mnkt_users WHERE user_email = %s", $email
                ));
                if ($existe > 0) {
                    $errores[] = "❌ Línea $linea: El email ya está registrado.";
                    continue;
                }

                // Crear usuario
                $password        = wp_generate_password();
                $hashed_password = wp_hash_password($password);

                $ok_user = $wpdb->insert('mnkt_users', [
                    'user_login'        => $nombre,
                    'user_nicename'     => sanitize_title($nombre),
                    'user_pass'         => $hashed_password,
                    'user_email'        => $email,
                    'display_name'      => $nombre,
                    'user_dni'          => $dni_numerico,
                    'user_cif'          => $user_cif,      // CIF de la empresa elegida
                    'user_cif_id'       => $empresa_id,    // id de empresa
                    'user_gamificacion' => $user_gamificacion,
                    'user_rol'          => 'Trabajador',
                    'user_estado'       => 'Activado',
                    'user_registered'   => current_time('mysql')
                ]);

                if ($ok_user === false) {
                    $errores[] = "❌ Línea $linea: Error al insertar usuario: {$wpdb->last_error}";
                    continue;
                }

                $nuevo_user_id = $wpdb->insert_id;

                // Asociación en empresas_usuarios (evitar duplicados)
                $ya_existe = (int) $wpdb->get_var($wpdb->prepare(
                    "SELECT COUNT(*) FROM {$tabla_empresas_usuarios} WHERE user_id = %d AND empresa_id = %d",
                    $nuevo_user_id, $empresa_id
                ));
                if ($ya_existe === 0) {
                    $wpdb->insert($tabla_empresas_usuarios, [
                        'user_id'        => $nuevo_user_id,
                        'empresa_id'     => $empresa_id,
                        'rol_en_empresa' => 'Trabajador',
                        'estado'         => 'Activado',
                        'creado_en'      => current_time('mysql'),
                    ], ['%d','%d','%s','%s','%s']);
                }

                // Email de bienvenida (si hay plantilla)
                $template_path = plugin_dir_path(dirname(__FILE__)) . 'templates/email-nuevo-trabajador.html';
                if (file_exists($template_path)) {
                    $email_body = file_get_contents($template_path);
                    $email_body = str_replace(
                        ['[user_login]', '[user_email]', '[password]'],
                        [$nombre, $email, $password],
                        $email_body
                    );

                    wp_mail($email, 'Bienvenido a E-Digitiall', $email_body, [
                        'Content-Type: text/html; charset=UTF-8',
                        'From: E-Digitiall <no-reply@educasede.com>'
                    ]);
                }

                $insertados_info[] = "$nombre ($email)";
                $insertados++;
            }
            fclose($handle);
        }

        // Resultado
        ob_start();
        echo '<div class="pure-alert pure-alert-success">';
        echo "✅ Se han añadido <strong>$insertados</strong> trabajador(es).<br>";

        if (!empty($insertados_info)) {
            echo "<br><strong>Insertados:</strong><ul>";
            foreach ($insertados_info as $ok) {
                echo "<li>✔️ $ok</li>";
            }
            echo "</ul>";
        }

        if (!empty($errores)) {
            echo "<hr><strong>Errores detectados:</strong><ul>";
            foreach ($errores as $err) {
                echo "<li>$err</li>";
            }
            echo "</ul>";
        }

        echo '</div>';
        $resultado_html = ob_get_clean();
    }

    // 4) UI (sin selector, usamos el de arriba; mantenemos empresa vía hidden)
    ob_start();
    ?>
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/pure/2.0.6/pure-min.css">
    <h3>Subir Trabajadores desde CSV</h3>
    <p><strong>Empresa seleccionada:</strong> <?php echo esc_html($empresa_label_txt); ?></p>
    <?php echo $resultado_html; ?>
    <form method="post" enctype="multipart/form-data" class="pure-form pure-form-stacked" action="">
        <input type="hidden" name="empresa_id" value="<?php echo (int)$empresa_id; ?>">
        <label>Archivo CSV: <input type="file" name="archivo_csv" accept=".csv" required></label>
        <input type="submit" name="cargar_csv_trabajadores" class="pure-button pure-button-primary boton-ajustado" value="Importar CSV">
        <p style="font-size: 0.85em; color: #555; margin-top: 8px;">
            El archivo CSV debe tener tres columnas: <strong>nombre</strong>, <strong>dni</strong> (solo números, sin letra) y <strong>email</strong>, en ese orden exacto. La primera fila debe ser el encabezado.
        </p>
        <p style="font-size: 0.85em; color: #555;">
            👉 Puedes descargar un ejemplo aquí: 
            <a href="https://docs.google.com/spreadsheets/d/1CiCHM66Rc3GWEvGus3sRyjZaZqQr94C8A2mkXC34WuY/export?format=csv" target="_blank">
                archivo-ejemplo.csv
            </a>
        </p>
    </form>
    <?php
    return ob_get_clean();
}



////////////////////////////////SHORTCODE SEPARADO PARA NUEVO TRABAJADOR //////////////////////

add_shortcode('nuevo_trabajador', 'formulario_nuevo_trabajador');

function formulario_nuevo_trabajador() {
    if (!is_user_logged_in()) {
        return '<p class="pure-alert" style="text-align: center;">No has iniciado sesión.</p>';
    }

    global $wpdb;
    $tabla_empresas = $wpdb->prefix . 'empresas';
$tabla_empresas_usuarios = $wpdb->prefix . 'empresas_usuarios';

    $current_user = wp_get_current_user();

    $usuario_actual = $wpdb->get_row($wpdb->prepare("SELECT * FROM mnkt_users WHERE user_email = %s", $current_user->user_email));

    if (!$usuario_actual || $usuario_actual->user_rol !== 'Gestor' || $usuario_actual->user_estado !== 'Activado') {
        return '<p class="pure-alert" style="text-align: center;">No tienes permisos para acceder a esta funcionalidad.</p>';
    }
// Flash message tras redirección
$flash_html = '';
if (isset($_GET['nuevo']) && $_GET['nuevo'] === 'ok') {
    $flash_html = '<p class="pure-alert pure-alert-success">🎉 Trabajador añadido correctamente y correo enviado.</p>';
}

// Empresas del gestor vía asociaciones (NO desde users)
$empresas = $wpdb->get_results($wpdb->prepare("
    SELECT DISTINCT e.id, e.user_cif, e.razon_social
    FROM {$wpdb->prefix}empresas_usuarios eu
    JOIN {$wpdb->prefix}empresas e ON e.id = eu.empresa_id
    WHERE eu.user_id = %d
      AND eu.rol_en_empresa = 'Gestor'
      AND eu.estado = 'Activado'
    ORDER BY e.razon_social ASC, e.user_cif ASC
", $usuario_actual->ID));

if (!$empresas) {
    return '<p class="pure-alert" style="text-align:center;">No tienes ninguna empresa asociada como Gestor.</p>';
}
// Índices para validar y mapear
$emp_index_by_id  = [];
$emp_index_by_cif = [];
foreach ($empresas as $e) {
    $emp_index_by_id[(int)$e->id]   = $e;
    $emp_index_by_cif[$e->user_cif] = $e;
}

// Empresa activa: 1) POST/GET empresa_id válido, 2) ?cif=..., 3) primera
$empresa_id = 0;
if (isset($_REQUEST['empresa_id']) && ctype_digit($_REQUEST['empresa_id']) && isset($emp_index_by_id[(int)$_REQUEST['empresa_id']])) {
    $empresa_id = (int) $_REQUEST['empresa_id'];
} elseif (isset($_GET['cif']) && isset($emp_index_by_cif[$_GET['cif']])) {
    $empresa_id = (int) $emp_index_by_cif[$_GET['cif']]->id;
} else {
    $empresa_id = (int) $empresas[0]->id;
}

// CIF de la empresa activa
$user_cif = $emp_index_by_id[$empresa_id]->user_cif;


$user_gamificacion = $usuario_actual->user_gamificacion;
$resultado_html = '';

 

    // Procesar alta de trabajador
    if (isset($_POST['nuevo_trabajador'])) {
        $nombre = sanitize_text_field($_POST['nombre']);
        $email = sanitize_email($_POST['email']);
        $dni = sanitize_text_field($_POST['dni']);

        if (!preg_match('/^[0-9]{6,8}$/', $dni)) {
            return '<p style="color:red;">Error: El DNI debe contener entre 6 y 8 números.</p>';
        }

        $existe_email = $wpdb->get_var($wpdb->prepare("SELECT COUNT(*) FROM mnkt_users WHERE user_email = %s", $email));
        if ($existe_email > 0) {
            return '<p style="color:red;">Error: El email ya está en uso.</p>';
        }

        $password = wp_generate_password();
        $hashed_password = wp_hash_password($password);

        $wpdb->insert('mnkt_users', [
            'user_login' => $nombre,
            'user_nicename' => sanitize_title($nombre),
            'user_pass' => $hashed_password,
            'user_email' => $email,
            'display_name' => $nombre,
            'user_dni' => $dni,
            'user_cif' => $user_cif,
            'user_cif_id'     => $empresa_id,  
            'user_gamificacion' => $user_gamificacion,
            'user_rol' => 'Trabajador',
            'user_estado' => 'Activado',
            'user_registered' => current_time('mysql')
        ]);

        $user_id = $wpdb->insert_id;
        // Asociar usuario a empresa (evitar duplicados)
$ya_existe = (int) $wpdb->get_var(
    $wpdb->prepare(
        "SELECT COUNT(*) FROM $tabla_empresas_usuarios WHERE user_id = %d AND empresa_id = %d",
        $user_id, $empresa_id
    )
);
if ($ya_existe === 0) {
    $wpdb->insert($tabla_empresas_usuarios, [
        'user_id'        => $user_id,
        'empresa_id'     => $empresa_id,
        'rol_en_empresa' => 'Trabajador',
        'estado'         => 'Activado',
        'creado_en'      => current_time('mysql'),
    ], ['%d','%d','%s','%s','%s']);
}

        wp_update_user(['ID' => $user_id, 'role' => 'trabajador']);

        // Enviar email con plantilla
        $template_path = plugin_dir_path(dirname(__FILE__)) . 'templates/email-nuevo-trabajador.html';
        if (file_exists($template_path)) {
            $email_body = file_get_contents($template_path);
            $email_body = str_replace(
                ['[user_login]', '[user_email]', '[password]'],
                [$nombre, $email, $password],
                $email_body
            );

            $headers = [
                'Content-Type: text/html; charset=UTF-8',
                'From: E-Digitiall <no-reply@educasede.com>'
            ];

            $enviado = wp_mail($email, 'Bienvenido a E-Digitiall', $email_body, $headers);

            if ($enviado) {
                error_log("✅ Email de nuevo trabajador enviado a $email");
            } else {
                error_log("❌ Falló el envío del email a $email");
            }
        } else {
            error_log("❌ No se encontró la plantilla de email en: $template_path");
        }
// Redirección post-POST para refrescar sin reenvío y mostrar mensaje
$base_url = ( is_ssl() ? 'https://' : 'http://' ) . $_SERVER['HTTP_HOST'] . $_SERVER['REQUEST_URI'];
$clean_url = remove_query_arg( ['nuevo'], $base_url );
$destino  = add_query_arg( ['nuevo' => 'ok'], $clean_url );
wp_safe_redirect( $destino );
exit;

        return '<p class="pure-alert pure-alert-success">🎉 Trabajador añadido correctamente y correo enviado.</p>';
    }

    // Mostrar formulario
    ob_start();
    ?>
<?php echo $flash_html; ?>

    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/pure/2.0.6/pure-min.css">
    <h3>Añadir Nuevo Trabajador</h3>
    <form method="post" class="pure-form pure-form-stacked">
        <label>Nombre: <input type="text" name="nombre" required></label>
        <label>Email: <input type="email" name="email" required></label>
        <label>DNI (sin la letra): <input type="text" name="dni" pattern="[0-9]{6,8}" required></label>
        <input type="hidden" name="empresa_id" value="<?php echo (int)$empresa_id; ?>">

        <input type="submit" name="nuevo_trabajador" class="pure-button pure-button-primary boton-ajustado" value="Añadir">
    </form>
   
    <?php
    return ob_get_clean();
}


?>



