<?php
// Shortcode: historico_horario_trabajador (Historial con filtros)
function rh_historico_horario_trabajador() {
    if (!is_user_logged_in()) {
        return '<p>Debes iniciar sesión para ver el historial.</p>';
    }

    global $wpdb;
    $user_id = get_current_user_id();
    $tabla = $wpdb->prefix . 'registro_horario';
    $usuarios = $wpdb->prefix . 'users';

    $user = get_userdata($user_id);
    $user_email = $user->user_email;

    // Obtener todos los CIF del gestor ACTIVOS
    $cif_registros = $wpdb->get_results($wpdb->prepare(
        "SELECT DISTINCT user_cif 
         FROM {$usuarios} 
         WHERE user_email = %s AND user_rol = 'Gestor' AND user_estado = 'Activado'",
        $user_email
    ));
    $cifs = array_map(fn($r) => $r->user_cif, $cif_registros);

    // Determinar CIF activo
    if (isset($_GET['cif']) && in_array($_GET['cif'], $cifs)) {
        $cif_activo = sanitize_text_field($_GET['cif']);
    } else {
        $cif_activo = $cifs[0] ?? null;
    }

    if (!$cif_activo) {
        return '<p>No tienes ningún CIF activo asignado.</p>';
    }

    // Calcular fechas para los filtros
    $hoy = date('Y-m-d');
    $ayer = date('Y-m-d', strtotime('-1 day'));
    $lunes_semana = date('Y-m-d', strtotime('monday this week'));
    $domingo_semana = date('Y-m-d', strtotime('sunday this week'));
    $lunes_semana_pasada = date('Y-m-d', strtotime('monday last week'));
    $domingo_semana_pasada = date('Y-m-d', strtotime('sunday last week'));
    $inicio_mes = date('Y-m-01');
    $inicio_mes_pasado = date('Y-m-01', strtotime('first day of last month'));
    $fin_mes_pasado = date('Y-m-t', strtotime('last day of last month'));

    // Obtener el filtro de fecha
    $filtro = $_GET['filtro'] ?? 'todos';
    $fecha_condicion = '';

    switch ($filtro) {
    case 'hoy':
        $fecha_condicion = "AND DATE(entradaR) = '$hoy'";
        break;
    case 'ayer':
        $fecha_condicion = "AND DATE(entradaR) = '$ayer'";
        break;
    case 'semana':
        $fecha_condicion = "AND DATE(entradaR) BETWEEN '$lunes_semana' AND '$domingo_semana'";
        break;
    case 'semana_pasada':
        $fecha_condicion = "AND DATE(entradaR) BETWEEN '$lunes_semana_pasada' AND '$domingo_semana_pasada'";
        break;
    case 'mes':
        $fecha_condicion = "AND DATE(entradaR) BETWEEN '$inicio_mes' AND '$hoy'";
        break;
    case 'mes_pasado':
        $fecha_condicion = "AND DATE(entradaR) BETWEEN '$inicio_mes_pasado' AND '$fin_mes_pasado'";
        break;
}


    ob_start();
    ?>

    <h3>Historial de Registros</h3>

    <?php if (count($cifs) > 1): ?>
    <form method="get" style="margin-bottom: 10px;">
        <label for="cif">Empresa:</label>
        <select name="cif" onchange="this.form.submit()">
            <?php foreach ($cifs as $cif): ?>
                <option value="<?php echo esc_attr($cif); ?>" <?php selected($cif, $cif_activo); ?>>
                    <?php echo esc_html($cif); ?>
                </option>
            <?php endforeach; ?>
        </select>
        <input type="hidden" name="filtro" value="<?php echo esc_attr($filtro); ?>">
    </form>
    <?php endif; ?>

   <h3>Historial de Registros</h3>

<table class="pure-table pure-table-bordered" style="width: 100%; text-align: center;">
    <thead>
        <tr>
            <th>Día</th>
            <th>Entrada</th>
            <th>Salida</th>
            <th>Tiempo</th>
            <th>Total del Día</th>
        </tr>
    </thead>
    <tbody>
    <?php

    $ids_trabajadores = $wpdb->get_col($wpdb->prepare(
    "SELECT ID FROM {$usuarios} WHERE user_cif = %s AND user_rol IN ('Trabajador', 'Gestor')",
    $cif_activo
));


    if (!empty($ids_trabajadores)) {
        $ids_string = implode(',', array_map('intval', $ids_trabajadores));
        $registros = $wpdb->get_results("
            SELECT * FROM $tabla 
            WHERE user_id IN ($ids_string) $fecha_condicion 
            ORDER BY entradaR DESC
        ");

        // Agrupar por día
        $dias = [];
        foreach ($registros as $r) {
            $fecha = date('Y-m-d', strtotime($r->entradaR));
            $dias[$fecha][] = $r;
        }

        $alternar = true;
        foreach ($dias as $fecha => $registros_dia) {
            // Calcular total del día
            $total_dia_segundos = 0;
            foreach ($registros_dia as $r) {
                if ($r->tiempo_totalR) {
                    list($h, $m, $s) = explode(':', $r->tiempo_totalR);
                    $total_dia_segundos += ($h * 3600) + ($m * 60) + $s;
                }
            }
            $total_dia = sprintf('%02d:%02d:%02d', floor($total_dia_segundos / 3600), floor(($total_dia_segundos % 3600) / 60), $total_dia_segundos % 60);

            $estilo_total_dia = '';
            if ($total_dia_segundos >= 43200) {
                $estilo_total_dia = "style='background-color: #f8d7da; color: red; font-weight: bold;'";
            } elseif ($total_dia_segundos >= 28800) {
                $estilo_total_dia = "style='color: red;'";
            }

            $estilo = $alternar ? 'background-color: #f5f5f5;' : 'background-color: #e0e0e0;';
            $alternar = !$alternar;

            $primero = true;
            $rowspan = count($registros_dia);
            $fecha_formateada = date('d/m/Y', strtotime($fecha));

            foreach ($registros_dia as $r) {
                $hora_entrada = date('H:i:s', strtotime($r->entradaR));
                $hora_salida = $r->salidaR ? date('H:i:s', strtotime($r->salidaR)) : '---';


                // (+1) si la salida es al día siguiente
                $dia_entrada = date('Y-m-d', strtotime($r->entradaR));
                $dia_salida = $r->salidaR ? date('Y-m-d', strtotime($r->salidaR)) : $dia_entrada;

                $sufijo_salida = ($dia_salida > $dia_entrada) ? "<sup style='color: gray;'>(+1)</sup>" : '';

                $linkEntrada = $r->latitud_entrada
                    ? "<a href='https://maps.google.com?q={$r->latitud_entrada},{$r->longitud_entrada}' target='_blank'>$hora_entrada</a>"
                    : $hora_entrada;

                $linkSalida = ($r->salida && $r->latitud_salida)
                    ? "<a href='https://maps.google.com?q={$r->latitud_salida},{$r->longitud_salida}' target='_blank'>$hora_salida$sufijo_salida</a>"
                    : ($r->salida ? "$hora_salida$sufijo_salida" : '---');

                $tiempo = $r->tiempo_totalR ?: '---';

                echo "<tr style='$estilo'>";
                if ($primero) {
                    echo "<td rowspan='$rowspan'>$fecha_formateada</td>";
                }

                echo "<td>$linkEntrada</td>
                      <td>$linkSalida</td>
                      <td>$tiempo</td>";

                if ($primero) {
                    echo "<td $estilo_total_dia rowspan='$rowspan'>$total_dia</td>";
                    $primero = false;
                }

                echo "</tr>";
            }
        }
    } else {
        echo "<tr><td colspan='5'>No hay trabajadores para este CIF.</td></tr>";
    }
    ?>
    </tbody>
</table>


    <?php
    return ob_get_clean();
}
add_shortcode('historico_horario_trabajador', 'rh_historico_horario_trabajador');

