<?php
// Evitar acceso directo
if (!defined('ABSPATH')) {
    exit;
}

// Función para guardar cambios en los trabajadores
function gt_guardar_trabajadores() {
    if (!isset($_POST['user_id']) || !current_user_can('edit_users')) {
        wp_die('No tienes permisos para realizar esta acción.');
    }

    $user_id = intval($_POST['user_id']);
    $nombre = isset($_POST['nombre']) ? sanitize_text_field($_POST['nombre']) : '';
    $email = isset($_POST['email']) ? sanitize_email($_POST['email']) : '';
    $dni = isset($_POST['dni']) ? sanitize_text_field($_POST['dni']) : '';
    $estado = isset($_POST['estado']) ? sanitize_text_field($_POST['estado']) : '';

    if (empty($user_id) || !get_userdata($user_id)) {
        wp_die('Error: El usuario no existe o el ID no es válido.');
    }

    // Intentar actualizar los datos del usuario
    $userdata = [
        'ID'           => $user_id,
        'display_name' => $nombre,
        'user_email'   => $email
    ];
    
    $result = wp_update_user($userdata);
    
    if (is_wp_error($result)) {
        wp_die('Error al actualizar el usuario: ' . $result->get_error_message());
    }

    // Guardar metadatos adicionales
    update_user_meta($user_id, 'dni', $dni);
    update_user_meta($user_id, 'estado', $estado);

    // Verificación de que los cambios fueron aplicados
    $updated_user = get_userdata($user_id);
    if ($updated_user) {
        error_log("✅ Usuario $user_id actualizado correctamente: " . print_r($updated_user, true));
    } else {
        error_log("❌ Error al obtener los datos del usuario después de la actualización.");
    }

    // Redirigir después de actualizar el usuario
    wp_redirect(home_url('/app'));
    exit;
}

// Registrar la acción correctamente
add_action('admin_post_guardar_trabajadores', 'gt_guardar_trabajadores');
add_action('admin_post_nopriv_guardar_trabajadores', 'gt_guardar_trabajadores');





// function gt_guardar_trabajadores() {
//     if (!isset($_POST['user_id']) || !current_user_can('gestor')) {
//         wp_die('No tienes permisos.');
//     }

//     $user_id = intval($_POST['user_id']);
//     $nombre = isset($_POST['nombre']) ? sanitize_text_field($_POST['nombre']) : '';
//     $email = isset($_POST['email']) ? sanitize_email($_POST['email']) : '';
//     $dni = isset($_POST['dni']) ? sanitize_text_field($_POST['dni']) : '';
//     $estado = isset($_POST['estado']) ? sanitize_text_field($_POST['estado']) : '';

//     if (empty($user_id) || !get_userdata($user_id)) {
//         wp_die('Error: El usuario no existe o el ID no es válido.');
//     }

//     // Intentar actualizar los datos del usuario
//     $userdata = [
//         'ID'           => $user_id,
//         'display_name' => $nombre,
//         'user_email'   => $email
//     ];
    
//     $result = wp_update_user($userdata);
    
//     if (is_wp_error($result)) {
//         wp_die('Error al actualizar el usuario: ' . $result->get_error_message());
//     }

//     // Guardar metadatos
//     if (!empty($dni)) {
//         update_user_meta($user_id, 'dni', $dni);
//     }
//     if (!empty($estado)) {
//         update_user_meta($user_id, 'estado', $estado);
//     }

//     // Verificación de que los cambios fueron aplicados
//     $updated_user = get_userdata($user_id);
//     if ($updated_user) {
//         error_log("✅ Usuario $user_id actualizado correctamente: " . print_r($updated_user, true));
//     } else {
//         error_log("❌ Error al obtener los datos del usuario después de la actualización.");
//     }

//     // Redirigir después de la actualización
//     wp_redirect($_SERVER['HTTP_REFERER']);
//     exit;
// }
// add_action('admin_post_guardar_trabajadores', 'gt_guardar_trabajadores');
// add_action('admin_post_nopriv_guardar_trabajadores', 'gt_guardar_trabajadores');