<?php
// Evitar acceso directo
if (!defined('ABSPATH')) {
    exit;
}

// Verificar permisos
if (!current_user_can('manage_options')) {
    wp_die(__('No tienes permisos para acceder a esta página.'));
}

// Cargar pestaña
$tab = isset($_GET['tab']) ? sanitize_text_field($_GET['tab']) : 'gestores';

$base_path = plugin_dir_path(__FILE__) . 'escritorio-backend/';
$mensaje = ''; // Mensajes de estado globales

echo '<h1>Control Horario</h1>';
echo '<p>Bienvenido al panel de control horario.</p>';

// Navegación de pestañas
?>
<h2 class="nav-tab-wrapper">
<a href="?page=control-horario&tab=empresas" class="nav-tab <?php echo ($tab === 'empresas') ? 'nav-tab-active' : ''; ?>">🏢 Empresas</a>
    <a href="?page=control-horario&tab=gestores" class="nav-tab <?php echo ($tab === 'gestores') ? 'nav-tab-active' : ''; ?>">👔 Gestores</a>
        <a href="?page=control-horario&tab=asignaciones" class="nav-tab <?php echo ($tab === 'asignaciones') ? 'nav-tab-active' : ''; ?>"> 🗃️ Asignaciones</a>

    <a href="?page=control-horario&tab=trabajadores" class="nav-tab <?php echo ($tab === 'trabajadores') ? 'nav-tab-active' : ''; ?>">🧑‍🦰 Trabajadores</a>
        <a href="?page=control-horario&tab=inspectores" class="nav-tab <?php echo ($tab === 'inspectores') ? 'nav-tab-active' : ''; ?>">👨‍💼Inspectores</a>
    <a href="?page=control-horario&tab=lugares" class="nav-tab <?php echo ($tab === 'lugares') ? 'nav-tab-active' : ''; ?>">🏡 Lugares</a>
            <a href="?page=control-horario&tab=resumen" class="nav-tab <?php echo ($tab === 'resumen') ? 'nav-tab-active' : ''; ?>">📧 Resumen</a>    
                    <a href="?page=control-horario&tab=revision" class="nav-tab <?php echo ($tab === 'revision') ? 'nav-tab-active' : ''; ?>"> 🔎 Revisión</a>
                    <a href="?page=control-horario&tab=rankings" class="nav-tab <?php echo ($tab === 'rankings') ? 'nav-tab-active' : ''; ?>"> Rankings</a>


    <a href="?page=control-horario&tab=notificaciones" class="nav-tab <?php echo ($tab === 'notificaciones') ? 'nav-tab-active' : ''; ?>">Notificaciones</a>
    <a href="?page=control-horario&tab=shortcodes" class="nav-tab <?php echo ($tab === 'shortcodes') ? 'nav-tab-active' : ''; ?>">Shortcodes</a>
        <a href="?page=control-horario&tab=config" class="nav-tab <?php echo ($tab === 'config') ? 'nav-tab-active' : ''; ?>">⚙️ Config</a>    

</h2>

<div class="wrap">
<?php
// Incluir el archivo de la pestaña seleccionada
switch ($tab) {
    case 'empresas':
        require_once $base_path . 'empresas.php';
        break;

    case 'gestores':
        require_once $base_path . 'gestores.php';
        break;

    case 'inspectores':
        require_once $base_path . 'inspectores.php';
        break;

    case 'trabajadores':
        require_once $base_path . 'trabajadores.php';
        break;
    case 'shortcodes':
        require_once $base_path . 'shortcodes.php';
        break;
        case 'config':
    require_once $base_path . 'escritorio_config.php';
    break;
    case 'lugares':
    require_once $base_path . 'lugares.php';
    break;
    case 'rankings':
    require_once $base_path . 'rankings.php';
    break;
     case 'revision':
    require_once $base_path . 'revision.php';
    break;
    case 'notificaciones':
    require_once $base_path . 'notificaciones.php';
    break;
    case 'asignaciones':
    require_once $base_path . 'asignaciones.php';
    break;
    case 'resumen':
    require_once $base_path . 'resumen.php';
    break;

    default:
        echo '<div class="notice notice-error"><p>❌ Pestaña no válida.</p></div>';
        break;
        
}
?>
</div>
