<?php
// Seguridad básica
if (!defined('ABSPATH')) exit;

// Procesar formulario al guardar
if (isset($_POST['logo_url_nonce']) && wp_verify_nonce($_POST['logo_url_nonce'], 'guardar_logo_url')) {
    if (current_user_can('manage_options')) {
        $logo_url = esc_url_raw($_POST['logo_url']);
        update_option('mi_plugin_logo_url', $logo_url);
        echo '<div class="notice notice-success"><p>✅ Logo actualizado correctamente.</p></div>';
    }
}

// Obtener la URL actual del logo
$logo_actual = esc_url(get_option('mi_plugin_logo_url', ''));
?>

<h2>Configuración del Logo</h2>
<form method="post">
    <?php wp_nonce_field('guardar_logo_url', 'logo_url_nonce'); ?>
    <table class="form-table">
        <tr>
            <th scope="row"><label for="logo_url">URL del logo de login</label></th>
            <td>
                <input type="url" name="logo_url" id="logo_url" value="<?php echo $logo_actual; ?>" class="regular-text" placeholder="https://...">
                <p class="description">Pega aquí la URL de la imagen que deseas usar como logo en la pantalla de login.</p>
            </td>
        </tr>
    </table>
    <?php submit_button('Guardar configuración'); ?>
</form>
