<?php

add_action('init', function () {
    if (isset($_GET['test_debug'])) {
        error_log("✅ TEST DEBUG FUNCIONANDO desde plugin");
    }
});

// Programar la tarea cron para ejecutar la función cada domingo a las 20:00
if (!wp_next_scheduled('enviar_resumen_trabajadores')) {
    wp_schedule_event(strtotime('next Sunday 20:00'), 'weekly', 'enviar_resumen_trabajadores');

}

add_action('enviar_resumen_trabajadores', 'enviar_resumen_semanal_trabajadores');

function enviar_resumen_semanal_trabajadores() {
    global $wpdb;

    $trabajadores = $wpdb->get_results("
        SELECT ID, user_email, user_login, user_gamificacion, user_cif
        FROM {$wpdb->prefix}users
        WHERE user_rol IN ('Trabajador', 'Gestor') AND user_estado = 'Activado'
    ");

    foreach ($trabajadores as $trabajador) {
        enviar_resumen_individual($trabajador);
    }
}
/**
 * Devuelve true si la empresa asociada al usuario está activada y permite envíos a trabajadores.
 * Busca por user_cif; si no hay, intenta por user_cif_id (si lo tuvieras).
 */
function ch_empresa_permite_envio_trabajador($user_id, $user_cif = '') {
    global $wpdb;

    // 1) Intentar por CIF del usuario
    if (!empty($user_cif)) {
        $row = $wpdb->get_row($wpdb->prepare(
            "SELECT estado_empresa, estado_envios_trabajadores
             FROM {$wpdb->prefix}empresas
             WHERE user_cif = %s
             LIMIT 1",
            $user_cif
        ));
        if ($row) {
            return (strtolower($row->estado_empresa) === 'activado'
                 && strtolower($row->estado_envios_trabajadores) === 'activado');
        }
    }

    // 2) Intentar por user_cif_id (si lo usas en tu tabla de usuarios)
    $empresa_id = (int)$wpdb->get_var($wpdb->prepare(
        "SELECT user_cif_id FROM {$wpdb->prefix}users WHERE ID = %d",
        $user_id
    ));
    if ($empresa_id > 0) {
        $row = $wpdb->get_row($wpdb->prepare(
            "SELECT estado_empresa, estado_envios_trabajadores
             FROM {$wpdb->prefix}empresas
             WHERE id = %d
             LIMIT 1",
            $empresa_id
        ));
        if ($row) {
            return (strtolower($row->estado_empresa) === 'activado'
                 && strtolower($row->estado_envios_trabajadores) === 'activado');
        }
    }

    // 3) Si no encontramos empresa, por seguridad NO enviamos
    return false;
}


function enviar_resumen_individual($trabajador) {
    global $wpdb;

    $user_id = $trabajador->ID;
    $email   = $trabajador->user_email;
    $nombre  = $trabajador->user_login;
    $cif     = $trabajador->user_cif;

    // ⛔ No enviar si la empresa está desactivada o tiene desactivados los envíos a trabajadores
if (!ch_empresa_permite_envio_trabajador($user_id, $cif)) {
    error_log("⛔ Saltando envío a trabajador ID {$user_id}: empresa desactivada o envíos desactivados.");
    return;
}


    // Rango: lunes incluido -> lunes siguiente no incluido
    $inicio_semana = date('Y-m-d 00:00:00', strtotime('monday this week'));
    $fin_semana    = date('Y-m-d 00:00:00', strtotime('monday next week'));

    // 🔹 Horario
    $registros = $wpdb->get_results($wpdb->prepare(
    "SELECT entradaR AS entrada, salidaR AS salida, latitud_entrada, longitud_entrada, latitud_salida, longitud_salida
     FROM {$wpdb->prefix}registro_horario 
     WHERE user_id = %d AND entradaR >= %s AND entradaR < %s",
    $user_id, $inicio_semana, $fin_semana
));


    if (empty($registros)) return; // No enviar si no hay registros


   $tiempo_total_segundos = 0;
$tiempo_por_dia = [];
$tablaPrincipalHTML = '';

if ($registros) {
    // Ordenar por entrada
    usort($registros, function ($a, $b) {
        return strtotime($a->entrada) - strtotime($b->entrada);
    });

    $tablaPrincipalHTML .= "<table style='width: 100%; border-collapse: collapse; font-family: Arial, sans-serif; margin-top: 15px;'>
        <thead>
            <tr style='background-color: #0073aa; color: white;'>
                <th style='padding: 10px; border: 1px solid #ddd; text-align: center;'>Entrada</th>
                <th style='padding: 10px; border: 1px solid #ddd; text-align: center;'>Salida</th>
                <th style='padding: 10px; border: 1px solid #ddd; text-align: center;'>Tiempo</th>
            </tr>
        </thead>
        <tbody>";

    $ultimo_dia = '';
    $color_toggle = false;

    foreach ($registros as $r) {
        $entrada_timestamp = strtotime($r->entrada);
        $salida_timestamp  = $r->salida ? strtotime($r->salida) : null;

        $dia_actual = date('Y-m-d', $entrada_timestamp);
        if ($dia_actual !== $ultimo_dia) {
            $color_toggle = !$color_toggle;
            $ultimo_dia = $dia_actual;
        }

        $color_fondo = $color_toggle ? '#f9f9f9' : '#e6f0f5';

        $entrada_txt = date('d/m/Y H:i', $entrada_timestamp);
      $salida_txt = $salida_timestamp ? date('d/m/Y H:i', $salida_timestamp) : 'Sin registrar';

// ⚠️ Añadir (¹) si cambia de día
if ($salida_timestamp && date('Y-m-d', $entrada_timestamp) !== date('Y-m-d', $salida_timestamp)) {
    if ($salida_timestamp && date('Y-m-d', $entrada_timestamp) !== date('Y-m-d', $salida_timestamp)) {
    $dias_diferencia = (strtotime(date('Y-m-d', $salida_timestamp)) - strtotime(date('Y-m-d', $entrada_timestamp))) / 86400;
    $dias_diferencia = (int)$dias_diferencia;
    if ($dias_diferencia > 0) {
        $salida_txt .= " <sup style='color:#999;'>(+{$dias_diferencia})</sup>";
    }
}


}


        // Calcular duración
        $tiempo_seg = ($entrada_timestamp && $salida_timestamp) ? ($salida_timestamp - $entrada_timestamp) : 0;
        $tiempo_total_segundos += $tiempo_seg;

        // 🧠 Repartir tiempo por día real
if ($entrada_timestamp && $salida_timestamp) {
    $inicio = $entrada_timestamp;
    $fin = $salida_timestamp;

    $actual = $inicio;
    while ($actual < $fin) {
        $dia_actual_loop = date('Y-m-d', $actual);
        $inicio_dia_siguiente = strtotime('tomorrow', $actual);
        $fin_tramo = min($fin, $inicio_dia_siguiente);
        $seg_tramo = $fin_tramo - $actual;

        if (!isset($tiempo_por_dia[$dia_actual_loop])) {
            $tiempo_por_dia[$dia_actual_loop] = 0;
        }

        $tiempo_por_dia[$dia_actual_loop] += $seg_tramo;
        $actual = $fin_tramo;
    }
} 

        // Hipervínculos entrada
        $entrada_link = ($r->latitud_entrada && $r->longitud_entrada)
            ? "<a href='https://www.google.com/maps?q={$r->latitud_entrada},{$r->longitud_entrada}' target='_blank' style='color: #0073aa; text-decoration: underline;'>$entrada_txt</a>"
            : $entrada_txt;

        // Hipervínculos salida
       $salida_link = ($r->latitud_salida && $r->longitud_salida)
    ? "<a href='https://www.google.com/maps?q={$r->latitud_salida},{$r->longitud_salida}' target='_blank' style='color: #0073aa; text-decoration: underline;'>$salida_txt</a>"
    : $salida_txt;

                        if ($tiempo_seg > 0) {
                            $horas = floor($tiempo_seg / 3600);
                            $minutos = floor(($tiempo_seg % 3600) / 60);
                            $duracion_fila = "{$horas}h {$minutos}m";
                        } else {
                            $duracion_fila = '—';
                        }

        $tablaPrincipalHTML .= "<tr style='background-color: $color_fondo;'>
            <td style='padding: 8px; text-align: center; border: 1px solid #ccc;'>$entrada_link</td>
            <td style='padding: 8px; text-align: center; border: 1px solid #ccc;'>$salida_link</td>
            <td style='padding: 8px; text-align: center; border: 1px solid #ccc;'>$duracion_fila</td>
        </tr>";
    }

    $horas = floor($tiempo_total_segundos / 3600);
    $minutos = floor(($tiempo_total_segundos % 3600) / 60);

    $tablaPrincipalHTML .= "</tbody></table>";

    // 💥 Bloque destacado para total
    $tablaPrincipalHTML .= "
    <div style='margin: 20px auto; max-width: 400px; padding: 20px; background: #dff0d8; border: 2px solid #a6d5a0; border-radius: 10px; text-align: center; font-size: 22px; font-weight: bold; color: #3c763d;'>
        ⏱️ Tiempo total trabajado esta semana: $horas h $minutos m
    </div>";

    // 🗓️ Tabla resumen horizontal por días
    $dias_semana = ['Monday'=>'Lunes', 'Tuesday'=>'Martes', 'Wednesday'=>'Miércoles', 'Thursday'=>'Jueves', 'Friday'=>'Viernes', 'Saturday'=>'Sábado', 'Sunday'=>'Domingo'];

    $tablaResumenHTML = "<table style='width: 100%; border-collapse: collapse; font-family: Arial, sans-serif; margin-top: 20px;'>
        <thead><tr style='background-color: #0073aa; color: white;'>";

    foreach ($dias_semana as $dia) {
        $tablaResumenHTML .= "<th style='padding: 10px; text-align: center; border: 1px solid #ccc;'>$dia</th>";
    }

    $tablaResumenHTML .= "</tr></thead><tbody><tr style='background-color: $color_fondo;'>";

    foreach (array_keys($dias_semana) as $day_key) {
        $duracion_txt = '—';
        foreach ($tiempo_por_dia as $fecha => $segundos) {
            if (date('l', strtotime($fecha)) === $day_key) {
                $h = floor($segundos / 3600);
                $m = floor(($segundos % 3600) / 60);
                $duracion_txt = "{$h}h {$m}m";
                break;
            }
        }
        $tablaResumenHTML .= "<td style='padding: 8px; text-align: center; border: 1px solid #ccc;'>$duracion_txt</td>";
    }

    $tablaResumenHTML .= "</tr></tbody></table>";
    $tablaPrincipalHTML .= "<div style='margin-top: 20px;'>$tablaResumenHTML</div>";

} else {
    $tablaPrincipalHTML = '<p style="text-align: center;">No hay registros de horario esta semana.</p>';
}




    // 🔹 Observaciones
    $observaciones = $wpdb->get_results($wpdb->prepare(
        "SELECT fecha_observacion, observaciones 
         FROM {$wpdb->prefix}observaciones 
         WHERE user_id = %d AND fecha_observacion BETWEEN %s AND %s",
        $user_id,
        date('Y-m-d', strtotime('monday this week')),
        date('Y-m-d', strtotime('sunday this week'))
    ));

    $tablaObservacionesHTML = '';
    if ($observaciones) {
        $tablaObservacionesHTML .= '<table><tr><th>Fecha</th><th>Observación</th></tr>';
        foreach ($observaciones as $obs) {
            $fecha = date('d/m/Y', strtotime($obs->fecha_observacion));
            $tablaObservacionesHTML .= "<tr><td>$fecha</td><td>{$obs->observaciones}</td></tr>";
        }
        $tablaObservacionesHTML .= '</table>';
    } else {
        $tablaObservacionesHTML = '<p style="text-align: center;">No hay observaciones esta semana.</p>';
    }

    // 🔹 Gamificación
    $gamificacionHTML = '';
    if ($trabajador->user_gamificacion == 1 && !empty($cif)) {
        $puntos = (int) $wpdb->get_var($wpdb->prepare(
            "SELECT COALESCE(SUM(puntos), 0) 
             FROM {$wpdb->prefix}registro_horario 
             WHERE user_id = %d AND entrada >= %s AND entrada < %s",
            $user_id, $inicio_semana, $fin_semana
        ));

        error_log("📊 PUNTOS para $nombre: $puntos entre $inicio_semana y $fin_semana");

        $ranking = $wpdb->get_results($wpdb->prepare(
            "SELECT u.ID, COALESCE(SUM(rh.puntos), 0) AS total_puntos
             FROM {$wpdb->prefix}users u
             LEFT JOIN {$wpdb->prefix}registro_horario rh 
             ON rh.user_id = u.ID AND rh.entrada >= %s AND rh.entrada < %s
             WHERE u.user_cif = %s AND u.user_estado = 'Activado' AND u.user_rol IN ('Trabajador', 'Gestor')
             GROUP BY u.ID
             ORDER BY total_puntos DESC",
            $inicio_semana, $fin_semana, $cif
        ));

        $posicion = 0;
        $total = count($ranking);
        foreach ($ranking as $i => $fila) {
            if ($fila->ID == $user_id) {
                $posicion = $i + 1;
                break;
            }
        }

        error_log("📈 Ranking: posición $posicion de $total para $nombre");

        // Nivel
        $nivel = 1;
        if ($posicion > 0 && $total > 0) {
            $percentil = $posicion / $total;
            if ($percentil <= 0.2) $nivel = 5;
            elseif ($percentil <= 0.4) $nivel = 4;
            elseif ($percentil <= 0.6) $nivel = 3;
            elseif ($percentil <= 0.8) $nivel = 2;
        }

        $frase = $wpdb->get_var($wpdb->prepare(
            "SELECT frase FROM {$wpdb->prefix}motivacion 
             WHERE nivel = %d AND grupo = 'inicio' ORDER BY RAND() LIMIT 1", $nivel
        ));
        $gif = $wpdb->get_var($wpdb->prepare(
            "SELECT gif_url FROM {$wpdb->prefix}motivacion 
             WHERE nivel = %d AND grupo = 'inicio' ORDER BY RAND() LIMIT 1", $nivel
        ));

        $gamificacionHTML = "
        <div class='gamificacion-box' style='text-align:center; font-family: Arial, sans-serif; margin-top: 20px; padding: 20px; border: 2px solid #ddd; border-radius: 12px; background: #f9f9f9;'>
            <div style='font-size: 26px; font-weight: bold; color: #333; margin-bottom: 10px;'>🏅 Ranking semanal</div>
            <div style='font-size: 22px; font-weight: bold; margin-bottom: 5px; color: #0073aa;'>#$posicion de $total</div>
            <div style='font-size: 18px; color: #555; margin-bottom: 20px;'>Has obtenido <strong>$puntos</strong> punto(s) esta semana 🎯</div>
            <div style='font-size: 20px; font-style: italic; color: #444; margin-bottom: 25px;'>“" . esc_html($frase) . "”</div>
            <div style='margin: 0 auto; max-width: 300px;'>
                <img src='" . esc_url($gif) . "' alt='Motivación nivel $nivel' style='max-width: 100%; border-radius: 8px;' />
            </div>
        </div>";

        error_log("✅ Gamificación generada: puntos=$puntos, ranking=$posicion de $total");
    }

    // 🔹 Plantilla
    $template_path = plugin_dir_path(__FILE__) . '../templates/resumen_semanal_trabajador.html';
    if (file_exists($template_path)) {
        $html = file_get_contents($template_path);
        $html = str_replace(
            ['${nombreTrabajador}', '${tablaPrincipalHTML}', '${tablaObservacionesHTML}', '${gamificacionHTML}'],
            [$nombre, $tablaPrincipalHTML, $tablaObservacionesHTML, $gamificacionHTML],
            $html
        );

        $headers = ['Content-Type: text/html; charset=UTF-8'];
        $asunto = "Resumen Semanal - $nombre";
        wp_mail($email, $asunto, $html, $headers);

        error_log("📤 Email de prueba enviado a $email");
    } else {
        error_log("❌ No se encontró la plantilla resumen_semanal_trabajador.html");
    }
}




///////////////////////////////////esto se puede borrar!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!

function enviar_resumen_a_email_prueba($usuario_input = '', $correo_destino = 'info@educasede.com') {
    global $wpdb;

    // Buscar usuario por login, email o ID
    if (is_numeric($usuario_input)) {
        $usuario = get_userdata((int)$usuario_input);
    } else {
        $usuario = $wpdb->get_row($wpdb->prepare(
            "SELECT * FROM {$wpdb->prefix}users WHERE user_login = %s OR user_email = %s LIMIT 1",
            $usuario_input, $usuario_input
        ));
    }

    if (!$usuario) {
        error_log("❌ Usuario no encontrado con identificador: $usuario_input");
        return;
    }

    // Sobrescribir email por destino de pruebas
    $usuario->user_email = $correo_destino;

    // Llamar función existente (asegúrate que tiene lógica de gamificación dentro)
    enviar_resumen_individual($usuario);

    error_log("✅ Email de prueba enviado al destino: $correo_destino con datos del usuario: {$usuario->user_login}");
}


add_action('init', function () {
    if (isset($_GET['enviar_test_a']) ) {

        error_log("🚀 Ejecutando prueba enviar_test_a con ID: " . $_GET['enviar_test_a']);

        global $wpdb;

        $usuario_input = sanitize_text_field($_GET['enviar_test_a']);
        $destino = isset($_GET['destino']) ? sanitize_email($_GET['destino']) : 'info@educasede.com';

        // Obtener usuario
        if (is_numeric($usuario_input)) {
            $usuario = get_userdata((int)$usuario_input);
        } else {
            $usuario = $wpdb->get_row($wpdb->prepare(
                "SELECT * FROM {$wpdb->prefix}users WHERE user_login = %s OR user_email = %s LIMIT 1",
                $usuario_input, $usuario_input
            ));
        }

        if (!$usuario) {
            echo "❌ Usuario no encontrado con identificador: $usuario_input";
            return;
        }

        // Forzar el correo de destino (modo prueba)
        $usuario->user_email = $destino;

        // Rango de fechas
        $inicio_semana = date('Y-m-d 00:00:00', strtotime('monday this week'));
        $fin_semana    = date('Y-m-d 00:00:00', strtotime('monday next week'));

        // Puntos del usuario
        $puntos = (int) $wpdb->get_var($wpdb->prepare(
            "SELECT COALESCE(SUM(puntos), 0) FROM {$wpdb->prefix}registro_horario 
             WHERE user_id = %d AND entrada >= %s AND entrada < %s",
            $usuario->ID, $inicio_semana, $fin_semana
        ));

        // Consulta SQL en modo texto
        $sql_debug = $wpdb->prepare(
            "SELECT puntos, entrada FROM {$wpdb->prefix}registro_horario 
             WHERE user_id = %d AND entrada >= %s AND entrada < %s",
            $usuario->ID, $inicio_semana, $fin_semana
        );

        // Ejecutar función original
        enviar_resumen_individual($usuario);

        // Mostrar en navegador
        echo "<h2>✅ Resumen de prueba enviado a <code>$destino</code></h2>";
        echo "<pre>";
        echo "📌 Usuario ID: {$usuario->ID}\n";
        echo "👤 Nombre: {$usuario->user_login}\n";
        echo "📧 Email: {$usuario->user_email}\n";
        echo "🏷️ CIF: {$usuario->user_cif}\n";
        echo "🗓️ Rango: $inicio_semana → $fin_semana\n";
        echo "🎯 Puntos obtenidos: $puntos\n";
        echo "\n🧪 SQL ejecutada:\n$sql_debug";
        echo "</pre>";
        exit;
    }
});


add_action('init', function () {
    if (isset($_GET['debug_puntos'])) {
        global $wpdb;

        $user_id = 10;
        $inicio_semana = '2025-04-07 00:00:00';
        $fin_semana    = '2025-04-13 23:59:59';

        $sql = $wpdb->prepare(
            "SELECT COALESCE(SUM(puntos), 0) FROM {$wpdb->prefix}registro_horario 
             WHERE user_id = %d AND entrada >= %s AND entrada < %s",
            $user_id, $inicio_semana, $fin_semana
        );

        $puntos = $wpdb->get_var($sql);

        echo "<pre>🔍 SQL:\n$sql\n\nPUNTOS TOTALES: $puntos</pre>";
        exit;
    }
});

///////////////////////FIN DE BORRAR//////////////////////////////////////////// PARA Enviar un ejemplo hay que 

/////////////// poner en el navegador https://www.educasede.com/app?enviar_test_a=93&destino=info@educasede.com
//////////el 93 es la id del trabajador y le llegará al correo de info@educasede.com una prueba. 


