<?php
/**
 * Plugin Name: Control horario de trabajadores
 * Description: Plugin para el control horario de trabajadores de E-Digitiall.
 * Version: 1.5
 * Author: Pablico :)
 */

// Evitar acceso directo
if (!defined('ABSPATH')) {
    exit;
}

// Iniciar sesión correctamente (evita headers already sent)
add_action('init', function () {
    if (session_status() === PHP_SESSION_NONE) {
        session_start();
    }
}, 1); // Prioridad 1 para que se ejecute lo más pronto posible

// Registrar roles con permisos correctos
function gt_registrar_roles() {
    add_role(
        'gestor',
        'Gestor',
        [
            'read'           => true,
            'edit_users'     => true,
            'delete_users'   => true,
            'list_users'     => true,
            'promote_users'  => true,
            'create_users'   => true,
            'manage_options' => true  // Permiso para administrar ajustes (opcional)
        ]
    );

    add_role(
        'trabajador',
        'Trabajador',
        [
            'read' => true
        ]
    );
    
    add_role(
        'inspector',
        'Inspector',
        [
            'read' => true
        ]
    );
}
register_activation_hook(__FILE__, 'gt_registrar_roles');

// Asegurar que los permisos se actualicen al cargar WordPress
function gt_actualizar_permisos_gestor() {
    $role = get_role('gestor');
    if ($role) {
        $role->add_cap('edit_users');
        $role->add_cap('delete_users');
        $role->add_cap('list_users');
        $role->add_cap('promote_users');
        $role->add_cap('create_users');
        $role->add_cap('manage_options'); // Opcional
    }
}
add_action('init', 'gt_actualizar_permisos_gestor');

// Evitar acceso a wp-admin, pero permitir solicitudes AJAX
function gt_restringir_admin() {
    if (
        is_admin()
        && !current_user_can('manage_options')
        && !defined('DOING_AJAX')
        && !(isset($_SERVER['PHP_SELF']) && strpos($_SERVER['PHP_SELF'], 'admin-post.php') !== false)
    ) {
        wp_redirect(home_url());
        exit;
    }
}

add_action('admin_init', 'gt_restringir_admin');

// Ocultar barra de administración para Gestor, Trabajador e Inspector
function gt_ocultar_admin_bar() {
    if (current_user_can('gestor') || current_user_can('trabajador') || current_user_can('inspector')) {
        show_admin_bar(false);
    }
}
add_action('after_setup_theme', 'gt_ocultar_admin_bar');

// Agregar menú en el escritorio de WordPress
function gt_agregar_menu_admin() {
    add_menu_page(
        'Control Horario',          // Título de la página
        'Control Horario',          // Nombre en el menú
        'manage_options',           // Capacidad requerida
        'control-horario',          // Slug del menú
        'gt_pagina_control_horario',// Función de contenido
        'dashicons-clock',          // Icono del menú
        25                          // Posición en el menú
    );
}
add_action('admin_menu', 'gt_agregar_menu_admin');

// Función que mostrará la página de administración
function gt_pagina_control_horario() {
    require_once plugin_dir_path(__FILE__) . 'includes/escritorio-control-horario.php';
}

// Función para verificar y crear tablas y columnas
function rh_crear_tabla_y_agregar_columnas() {
    global $wpdb;
    
    // Asegurar que se tiene acceso a la función dbDelta
    require_once ABSPATH . 'wp-admin/includes/upgrade.php';

    $charset_collate = $wpdb->get_charset_collate();



////// HE TENIDO QUE CREAR ESTA TABLA MUCHOS A MUCHOS M2M PARA RELACIONAR LOS GESTORES CON VARIAS EMPRESAS  CON MYSQL DIRECTAMENTE 
//CREATE TABLE IF NOT EXISTS mnkt_empresas_usuarios (
  //id BIGINT(20) UNSIGNED AUTO_INCREMENT PRIMARY KEY,
  //user_id BIGINT(20) UNSIGNED NOT NULL,
 // empresa_id BIGINT(20) UNSIGNED NOT NULL,
  //rol_en_empresa ENUM('Gestor','Técnico','Trabajador') NOT NULL DEFAULT 'Gestor',
 // estado ENUM('Activado','Desactivado') NOT NULL DEFAULT 'Activado',
  //creado_en DATETIME NOT NULL DEFAULT CURRENT_TIMESTAMP,
  //UNIQUE KEY uniq_user_empresa_rol (user_id, empresa_id, rol_en_empresa),
  //KEY idx_empresa (empresa_id),
  //KEY idx_user (user_id)
//) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

    // Definir tablas y sus estructuras
    $tablas = [
        $wpdb->prefix . 'registro_horario' => [
    "id BIGINT(20) UNSIGNED AUTO_INCREMENT PRIMARY KEY",
    "user_id BIGINT(20) NOT NULL",                     // trabajador
    "cif_usuario VARCHAR(20) NOT NULL",                // CIF de la empresa (texto)
    "cif_id BIGINT(20) UNSIGNED DEFAULT NULL",         // 🔗 relación con mnkt_empresas.id
    "lugar_id BIGINT(20) UNSIGNED DEFAULT NULL",       // 🔗 relación con mnkt_lugares.id (puede ser NULL si no aplica)
    "entrada DATETIME DEFAULT NULL",
    "salida DATETIME DEFAULT NULL",
    "tiempo_total TIME DEFAULT NULL",
    "latitud_entrada DECIMAL(10,8) DEFAULT NULL",
    "longitud_entrada DECIMAL(11,8) DEFAULT NULL",
    "latitud_salida DECIMAL(10,8) DEFAULT NULL",
    "longitud_salida DECIMAL(11,8) DEFAULT NULL",
    "puntos INT DEFAULT 0",
    "entradaR DATETIME DEFAULT NULL",
    "salidaR DATETIME DEFAULT NULL",
    "tiempo_totalR TIME DEFAULT NULL"
],


        $wpdb->prefix . 'observaciones' => [
            "id BIGINT(20) UNSIGNED AUTO_INCREMENT PRIMARY KEY",
            "user_id BIGINT(20) NOT NULL",
            "cif_usuario VARCHAR(20) NOT NULL",
            "fecha_observacion DATE NOT NULL",
            "observaciones VARCHAR(250) NOT NULL"
        ], 
        $wpdb->prefix . 'motivacion' => [
            "id INT AUTO_INCREMENT PRIMARY KEY",
            "nivel INT NOT NULL",
            "frase TEXT",
            "gif_url TEXT",
            "grupo VARCHAR(50) DEFAULT 'general'"
        ],
        $wpdb->prefix . 'solicitudes' => [
            "id BIGINT(20) UNSIGNED AUTO_INCREMENT PRIMARY KEY",
            "user_id BIGINT(20) NOT NULL",
            "cif_usuario VARCHAR(20) NOT NULL",
            "tipo ENUM('vacaciones', 'permiso') NOT NULL",
            "fecha_inicio DATE NOT NULL",
            "fecha_fin DATE NOT NULL",
            "motivo TEXT NULL",
            "estado ENUM('pendiente', 'aprobado', 'rechazado') DEFAULT 'pendiente'",
            "fecha_solicitud DATETIME DEFAULT CURRENT_TIMESTAMP",
            "gestionado_por BIGINT(20) NULL",
            "fecha_gestion DATETIME NULL"
        ],
        

        $wpdb->prefix . 'shortcodes_info' => [
            "id BIGINT(20) UNSIGNED AUTO_INCREMENT PRIMARY KEY",
            "shortcode VARCHAR(100) NOT NULL",
            "descripcion TEXT NOT NULL"
        ],
               
       $wpdb->prefix . 'empresas' => [
        "id BIGINT(20) UNSIGNED AUTO_INCREMENT PRIMARY KEY",
        "user_id BIGINT(20) NOT NULL",
        "user_cif VARCHAR(20) NOT NULL",
        "razon_social VARCHAR(255) DEFAULT ''",
        "direccion_facturacion TEXT DEFAULT NULL",
        "aceptacion_proteccion_datos TINYINT(1) DEFAULT 0",
        "aceptacion_sepa TINYINT(1) DEFAULT 0",
        "metodo_pago ENUM('Domiciliación','Tarjeta','Transferencia','') DEFAULT ''",
        "fecha_aceptacion DATETIME DEFAULT NULL",
        "ip_firma VARCHAR(45) DEFAULT NULL",
        "user_agent TEXT DEFAULT NULL",

        // NUEVO: Stripe + Trial
        "stripe_customer_id VARCHAR(64) DEFAULT NULL",
        "stripe_subscription_id VARCHAR(64) DEFAULT NULL",
        "trial_started_at DATETIME DEFAULT NULL",
        "trial_days INT NOT NULL DEFAULT 35",
        "trial_status ENUM('en_curso','convertido','expirado') NOT NULL DEFAULT 'en_curso'",
        "trial_expires_at DATETIME DEFAULT NULL",
        "deactivated_at DATETIME DEFAULT NULL",

        "estado_validacion ENUM('Pendiente','Validado','Expirado') DEFAULT 'Pendiente'",
        "documentos_generados TINYINT(1) DEFAULT 0",
        "estado_empresa ENUM('activado','desactivado') DEFAULT 'activado'",
        "estado_envios_trabajadores ENUM('activado','desactivado') DEFAULT 'activado'",
        "qr_general ENUM('activado','desactivado') DEFAULT 'desactivado'",
        "estado_lugares ENUM('activado','desactivado') DEFAULT 'desactivado'",
        "total_lugares INT DEFAULT 0",
        "gamificacion ENUM('activado','desactivado') NOT NULL DEFAULT 'desactivado'"
    ],


        $wpdb->prefix . 'lugares' => [
            "id BIGINT(20) UNSIGNED AUTO_INCREMENT PRIMARY KEY",
            "empresa_id BIGINT(20) UNSIGNED NOT NULL", // Relación con empresas
            "nombre_lugar VARCHAR(255) NOT NULL", // Nombre o etiqueta del lugar
            "direccion TEXT DEFAULT NULL", // Dirección opcional
            "qr_code TEXT DEFAULT NULL", // Código QR opcional
            "tipo_acceso ENUM('libre', 'restringido') DEFAULT 'libre'", // Tipo de acceso
            "estado ENUM('activado', 'desactivado') DEFAULT 'activado'", // Estado del lugar
            "created_at DATETIME DEFAULT CURRENT_TIMESTAMP",
            "updated_at DATETIME DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP"
        ]

    ];

    // Crear o actualizar las tablas si no existen
    foreach ($tablas as $nombre_tabla => $columnas) {
        if ($wpdb->get_var("SHOW TABLES LIKE '$nombre_tabla'") != $nombre_tabla) {
            $sql = "CREATE TABLE $nombre_tabla (" . implode(", ", $columnas) . ") $charset_collate;";
            dbDelta($sql);
        } else {
            // Verificar si cada columna existe y agregarla si es necesario
            $columnas_existentes = $wpdb->get_col("SHOW COLUMNS FROM $nombre_tabla");
            foreach ($columnas as $columna) {
                $nombre_columna = explode(" ", $columna)[0]; // Extraer el nombre de la columna
                if (!in_array($nombre_columna, $columnas_existentes)) {
                    $wpdb->query("ALTER TABLE $nombre_tabla ADD COLUMN $columna;");
                }
            }
        }
    }

    // Verificar y agregar columnas a la tabla de usuarios
    $tabla_usuarios = $wpdb->prefix . 'users';
  $columnas_usuarios = [
    'user_dni'           => 'VARCHAR(10) NULL',
    'user_cif'           => 'VARCHAR(10) NULL',
    'user_cif_id'        => 'BIGINT(20) UNSIGNED NULL', // 👈 Nueva columna (id de empresa)
    'user_gamificacion'  => 'TINYINT(1) NULL',
    'user_estado'        => "ENUM('Activado','Desactivado') DEFAULT 'Activado'",
    'qr_token'           => 'VARCHAR(64) NULL' // QR seguro
];


    $columnas_existentes_usuarios = $wpdb->get_col("SHOW COLUMNS FROM $tabla_usuarios");
    foreach ($columnas_usuarios as $columna => $tipo) {
        if (!in_array($columna, $columnas_existentes_usuarios)) {
            $wpdb->query("ALTER TABLE $tabla_usuarios ADD COLUMN $columna $tipo;");
        }
    }
}

// Registrar la función para ejecutarse al activar el plugin
if (function_exists('register_activation_hook')) {
    register_activation_hook(__FILE__, 'rh_crear_tabla_y_agregar_columnas');
}

// Función para incluir los estilos CSS del plugin
function mi_plugin_agregar_estilos() {
    wp_enqueue_style(
        'mi-plugin-css',
        plugins_url('css/estilos.css', __FILE__),
        array(),
        time()
    );
}
add_action('wp_enqueue_scripts', 'mi_plugin_agregar_estilos');

// Incluir archivos adicionales necesarios para el plugin
$includes = [
    'listar-trabajadores.php',
    'guardar-trabajador.php',
    'eliminar-trabajador.php',
    'acceso-trabajadores.php',
    'registro-entradas-salidas.php',
    //'historico-entradas-salidas.php',
    'rankings-front.php',
    'registro-entradas-salidas-solicitud-cambios.php',
    'revision_trabajadores_resolucion_solicitudes.php',
    'consultar-trabajadores.php',
    'gestion-inspectores.php',
    'ticaje-externo.php',
    'revision_trabajadores.php',
    'qr-movil.php',
    'envio_semanal_trabajador.php',
    'gamificacion.php',
    'nuevo_gestor_front.php',
    'device-access.php',
    'envio_semanal_empresa.php',
    'rol-menu.php',
    'generar_pdf.php',
    'solicitudes.php',
    'gestion-solicitudes.php',
    'cuenta.php',
    'lector-qr.php',
    'test.php',
    'revision_trabajadores_inspeccion.php',
    'gestion-lugares.php',
    'formulario_inscripcion.php',
    'mi_cuenta.php'
];

foreach ($includes as $file) {
    require_once plugin_dir_path(__FILE__) . 'includes/' . $file;
}

// Registrar la última conexión de un usuario en user_meta
add_action('wp_login', 'registrar_ultima_conexion_madrid', 10, 2);

function registrar_ultima_conexion_madrid($user_login, $user) {
    // Hora actual en Madrid
    $fecha_madrid = new DateTime('now', new DateTimeZone('Europe/Madrid'));
    $timestamp = $fecha_madrid->format('Y-m-d H:i:s');

    // Guarda en user_meta
    update_user_meta($user->ID, 'ultima_conexion_madrid', $timestamp);
}

// Añadir logo personalizado a la página de login
function mi_plugin_logo_login() {
    $logo_url = esc_url(get_option('mi_plugin_logo_url'));
    if (!$logo_url) return; // Salir si no hay logo definido
    ?>
    <style type="text/css">
        #login h1 a {
            background-image: url('<?php echo $logo_url; ?>');
            background-size: contain;
            background-repeat: no-repeat;
            width: 100%;
            height: 100px;
        }
    </style>
    <?php
}

add_action('login_head', 'mi_plugin_logo_login');

// Cambiar la URL del logo (va al inicio del sitio)
function mi_plugin_login_url() {
    return home_url();
}
add_filter('login_headerurl', 'mi_plugin_login_url');

// Cambiar el texto del logo (tooltip)
function mi_plugin_login_title() {
    return get_bloginfo('name');
}
add_filter('login_headertext', 'mi_plugin_login_title');

// Acciones AJAX de prueba
add_action('wp_ajax_nopriv_probar_ajax', function () {
    echo 'Funciona AJAX'; // Esto es lo que se espera que aparezca
    wp_die();
});

add_action('wp_ajax_probar_ajax', 'probar_ajax_callback');
add_action('wp_ajax_nopriv_probar_ajax', 'probar_ajax_callback');

function probar_ajax_callback() {
    echo 'Funciona AJAX';
    wp_die(); // importante para terminar correctamente
}


// Encolar script JS para sugerencia de instalación PWA (cada X días)
add_action('wp_enqueue_scripts', 'gt_enqueue_install_prompt_script');

function gt_enqueue_install_prompt_script() {
    if (!is_admin()) {
        wp_enqueue_script(
            'gt-install-prompt',
            plugins_url('js/pwa.js', __FILE__),
            [],
            '1.0',
            true
        );
    }
}

add_action('wp_head', 'gt_insertar_manifest_y_meta_pwa');

function gt_insertar_manifest_y_meta_pwa() {
    $current_uri = $_SERVER['REQUEST_URI'];

    // Selección del manifest según si estamos en /externo o no
    $manifest_path = plugins_url('manifest.json', __FILE__);
    if (strpos($current_uri, '/externo') !== false) {
        $manifest_path = plugins_url('externo/manifest.json', __FILE__);
    }

    // Inyección del manifest y del service worker (ideal para PWA completa en /app)
    echo '<link rel="manifest" href="' . esc_url($manifest_path) . '">' . "\n";
    echo '<meta name="theme-color" content="#0073aa">' . "\n";
    echo '<script>
        if ("serviceWorker" in navigator) {
            navigator.serviceWorker.register("/app/sw.js")
                .then(function(reg) {
                    console.log("✅ Service Worker registrado con éxito:", reg.scope);
                })
                .catch(function(error) {
                    console.error("❌ Error al registrar el Service Worker:", error);
                });
        }
    </script>';
}


add_action('init', 'gt_servir_service_worker');

function gt_servir_service_worker() {
    if ($_SERVER['REQUEST_URI'] === '/sw.js') {
        header('Content-Type: application/javascript');
        readfile(plugin_dir_path(__FILE__) . 'sw.js');
        exit;
    }
}



////PAra el calendario de la solicitudes

function cargar_fullcalendar_librerias() {
    wp_enqueue_style('fullcalendar-css', 'https://cdn.jsdelivr.net/npm/fullcalendar@6.1.11/main.min.css');
    wp_enqueue_script('fullcalendar-js', 'https://cdn.jsdelivr.net/npm/fullcalendar@6.1.11/main.min.js', array('jquery'), null, true);
}
add_action('wp_enqueue_scripts', 'cargar_fullcalendar_librerias');



///////////////////Validar fichaje en el qr   

add_action('wp_ajax_validar_fichaje', 'qr_validar_fichaje');
add_action('wp_ajax_nopriv_validar_fichaje', 'qr_validar_fichaje');

function qr_validar_fichaje() {
    check_ajax_referer('qr_fichaje_nonce', 'nonce');

    global $wpdb;
    $tabla_users = $wpdb->prefix . 'users';
    $tabla_registro = $wpdb->prefix . 'registro_horario';

    $token = sanitize_text_field($_POST['dni']); // es el token del QR

    $usuario = $wpdb->get_row($wpdb->prepare("SELECT ID, user_cif FROM $tabla_users WHERE qr_token = %s", $token));

    if (!$usuario) {
        wp_send_json(['registro_permitido' => false, 'mensaje' => '❌ Token inválido.']);
    }

    $user_id = $usuario->ID;

    // Comprobar si hay registro sin salida
    $registro_abierto = $wpdb->get_row($wpdb->prepare(
        "SELECT * FROM $tabla_registro WHERE user_id = %d AND salida IS NULL ORDER BY id DESC LIMIT 1", $user_id
    ));

    $tipo = $registro_abierto ? 'salida' : 'entrada';

    wp_send_json([
        'registro_permitido' => true,
        'tipo' => $tipo,
        'mensaje' => "✅ Escaneo correcto. Registrar $tipo."
    ]);
}