<?php
if (!defined('ABSPATH')) exit;

/**
 * Link: https://tudominio.com/app/?ch_stripe_portal=1
 * Requiere: usuario logueado con relación a una empresa que tenga stripe_customer_id
 * Usa: CONTROL_HORARIO_STRIPE_SECRET_KEY (wp-config.php) o la opción ch_stripe_secret_key
 */
add_action('init', function () {
    add_rewrite_tag('%ch_stripe_portal%', '1');
});

add_action('template_redirect', function () {
    if (!isset($_GET['ch_stripe_portal'])) return;

    if (!is_user_logged_in()) {
        auth_redirect(); // fuerza login
        return;
    }

    // 1) Buscar empresa del usuario actual (Gestor)
    $user_id = get_current_user_id();
    global $wpdb;
    $t_rel   = 'mnkt_empresas_usuarios';
    $t_emp   = 'mnkt_empresas';

    $empresa = $wpdb->get_row($wpdb->prepare("
        SELECT e.id, e.stripe_customer_id
        FROM {$t_emp} e
        INNER JOIN {$t_rel} r ON r.empresa_id = e.id
        WHERE r.user_id = %d AND r.rol_en_empresa = 'Gestor' AND r.estado='Activado'
        ORDER BY r.creado_en DESC
        LIMIT 1
    ", $user_id));

    if (!$empresa || empty($empresa->stripe_customer_id)) {
        wp_die('No hay cliente de Stripe asociado a tu cuenta.', 'Portal de pagos', ['response'=>403]);
    }

    // 2) Cargar Stripe SDK
    if (defined('CH_STRIPE_WH_PLUGIN_DIR')) {
        $sdk = CH_STRIPE_WH_PLUGIN_DIR . 'lib/stripe-php/init.php';
    } else {
        $sdk = trailingslashit(dirname(__DIR__)) . 'lib/stripe-php/init.php';
    }
    if (file_exists($sdk)) require_once $sdk;
    if (!class_exists('\Stripe\StripeClient')) {
        wp_die('Stripe SDK no disponible.', 'Portal de pagos', ['response'=>500]);
    }

    // 3) Conseguir la API Secret
    $secret = defined('CONTROL_HORARIO_STRIPE_SECRET_KEY')
        ? CONTROL_HORARIO_STRIPE_SECRET_KEY
        : get_option('ch_stripe_secret_key', '');

    if (!$secret) {
        wp_die('Clave de Stripe no configurada.', 'Portal de pagos', ['response'=>500]);
    }

    // 4) Crear sesión del Billing Portal
    try {
        $client = new \Stripe\StripeClient($secret);

        $return_url = site_url('/'); // cambia si quieres volver a /app/ o /mi-cuenta/
        $session = $client->billingPortal->sessions->create([
            'customer'   => $empresa->stripe_customer_id,
            'return_url' => $return_url,
            // Opcional: limitar secciones del portal
            // 'flow_data' => [ ... ],
        ]);

        wp_redirect($session->url);
        exit;
    } catch (\Throwable $e) {
        error_log('[CH Portal] Error creando sesión portal: '.$e->getMessage());
        wp_die('No se pudo abrir el portal de pagos. Contacta soporte.', 'Portal de pagos', ['response'=>500]);
    }
});
