// Detectar si la app ya está instalada
const isStandalone = window.matchMedia('(display-mode: standalone)').matches || window.navigator.standalone === true;
const isIOS = /iphone|ipad|ipod/.test(window.navigator.userAgent.toLowerCase());
const isInStandaloneMode = ('standalone' in window.navigator) && window.navigator.standalone;

// Mostrar aviso para iOS si no está instalada
if (isIOS && !isInStandaloneMode) {
  // Puedes reemplazar esto con un banner o modal
  alert('Para instalar esta app en tu iPhone, pulsa el botón de compartir y selecciona "Agregar a pantalla de inicio".');
}

// Salir si la app ya está instalada
if (isStandalone) {
  console.log('App ya está instalada. No se mostrará el botón.');
  return;
}

// Registro del service worker (necesario para PWA)
if ('serviceWorker' in navigator) {
  navigator.serviceWorker.register('/sw.js')
    .then(reg => console.log('Service Worker registrado:', reg))
    .catch(err => console.log('Error al registrar Service Worker:', err));
}

let deferredPrompt;
let lastPromptTime = localStorage.getItem('lastPromptTime') || 0;
const daysBetweenPrompts = 3;

window.addEventListener('beforeinstallprompt', (e) => {
  e.preventDefault();
  deferredPrompt = e;

  const now = Date.now();
  const daysSinceLast = (now - lastPromptTime) / (1000 * 60 * 60 * 24);

  if (daysSinceLast >= daysBetweenPrompts) {
    const installBtn = document.createElement('button');
    installBtn.innerText = 'Instala esta app';
    installBtn.style.position = 'fixed';
    installBtn.style.bottom = '20px';
    installBtn.style.right = '20px';
    installBtn.style.zIndex = '9999';
    installBtn.style.padding = '10px 15px';
    installBtn.style.background = '#0073aa';
    installBtn.style.color = '#fff';
    installBtn.style.border = 'none';
    installBtn.style.borderRadius = '5px';
    installBtn.style.cursor = 'pointer';

    document.body.appendChild(installBtn);

    installBtn.addEventListener('click', () => {
      deferredPrompt.prompt();
      deferredPrompt.userChoice.then((choiceResult) => {
        deferredPrompt = null;
        installBtn.remove();
        localStorage.setItem('lastPromptTime', Date.now());
      });
    });
  }
});
