<?php
try {
    require_once __DIR__ . '/../dompdf/autoload.inc.php';
    error_log('✅ DomPDF cargado correctamente');
} catch (Exception $e) {
    error_log('❌ Error al cargar DomPDF: ' . $e->getMessage());
}


use Dompdf\Dompdf;

add_action('admin_post_generar_pdf_fichajes', 'pluggin_generar_pdf_fichajes');
add_action('admin_post_nopriv_generar_pdf_fichajes', 'pluggin_generar_pdf_fichajes');

function pluggin_generar_pdf_fichajes() {
    if (!isset($_POST['pdf_trabajador_id'], $_POST['pdf_fecha_inicio'], $_POST['pdf_fecha_fin'])) {
        wp_die('❌ Faltan datos.');
    }

    global $wpdb;

    $trabajador_id = intval($_POST['pdf_trabajador_id']);
    $fecha_inicio = sanitize_text_field($_POST['pdf_fecha_inicio']);
    $incluir_observaciones = isset($_POST['incluir_observaciones']) && $_POST['incluir_observaciones'] == '1';
    $fecha_fin = sanitize_text_field($_POST['pdf_fecha_fin']);

    $usuario = get_userdata($trabajador_id);
    if (!$usuario) {
        wp_die('❌ Usuario no encontrado.');
    }

    $dni = trim((string)($usuario->user_dni ?? ''));
    $dni_mostrar = $dni !== '' ? $dni : 'sin DNI';
    $nombre = esc_html($usuario->display_name . ' (' . $dni_mostrar . ')');
    // Obtener registros
    $registros = $wpdb->get_results($wpdb->prepare(
        "SELECT entradaR, salidaR, tiempo_totalR 
         FROM {$wpdb->prefix}registro_horario 
         WHERE user_id = %d 
         AND DATE(entradaR) BETWEEN %s AND %s 
         ORDER BY entradaR DESC",
        $trabajador_id, $fecha_inicio, $fecha_fin
    ));

    $html = '<style>
        body { font-family: Arial, sans-serif; font-size: 12px; }
        h1 { text-align: center; color: #0073aa; }
        table { width: 100%; border-collapse: collapse; margin-top: 20px; }
        th, td { padding: 8px; border: 1px solid #ccc; text-align: center; }
        th { background-color: #0073aa; color: white; }
    </style>';

    $html .= "<h1>Resumen de Fichajes</h1>";
    $html .= "<p><strong>Trabajador:</strong> $nombre<br>
          <strong>Desde:</strong> " . date('d-m-Y', strtotime($fecha_inicio)) . " &nbsp;&nbsp; 
          <strong>Hasta:</strong> " . date('d-m-Y', strtotime($fecha_fin)) . "</p>";


    if ($registros) {
 $html .= "<table><thead><tr>
    <th>Entrada</th><th>Salida</th><th>Tiempo</th><th>Total día</th>
</tr></thead><tbody>";

$registros_por_dia = [];

// Agrupar por fecha (Y-m-d)
foreach ($registros as $registro) {
    if (!$registro->entradaR) continue;
    $fecha = date('Y-m-d', strtotime($registro->entradaR));
    $registros_por_dia[$fecha][] = $registro;
}

// Orden descendente por día (como en tu tabla web)
krsort($registros_por_dia);

$alternar_dia = false;

foreach ($registros_por_dia as $fecha => $registros_dia) {
    $rowspan = count($registros_dia);
    $total_segundos_dia = 0;

    // Cambiar color cada día
    $alternar_dia = !$alternar_dia;
    $fondo_dia = $alternar_dia ? '#f9f9f9' : '#ffffff';

    // Calcular total del día
    foreach ($registros_dia as $r) {
        if ($r->entradaR && $r->salidaR) {
            $inicio = strtotime($r->entradaR);
            $fin = strtotime($r->salidaR);
            if ($fin > $inicio) {
                $total_segundos_dia += ($fin - $inicio);
            }
        }
    }

    foreach ($registros_dia as $i => $registro) {
        $entrada_txt = $registro->entradaR ? date('d/m/Y H:i', strtotime($registro->entradaR)) : '—';
        $salida_txt  = $registro->salidaR  ? date('d/m/Y H:i', strtotime($registro->salidaR)) : 'Falta salida';

        $tiempo_exacto = '00:00:00';
        $segundos_registro = 0;

        if ($registro->entradaR && $registro->salidaR) {
            $inicio = strtotime($registro->entradaR);
            $fin = strtotime($registro->salidaR);
            if ($fin > $inicio) {
                $segundos_registro = $fin - $inicio;
                $tiempo_exacto = sprintf('%02d:%02d:%02d',
                    floor($segundos_registro / 3600),
                    floor(($segundos_registro % 3600) / 60),
                    $segundos_registro % 60
                );
            }
        }

        $html .= "<tr>
    <td style='background-color: $fondo_dia;'>$entrada_txt</td>
    <td style='background-color: $fondo_dia;'>$salida_txt</td>
    <td style='background-color: $fondo_dia;'>$tiempo_exacto</td>";


        if ($i === 0) {
            $total_txt = sprintf('%02d:%02d:%02d',
                floor($total_segundos_dia / 3600),
                floor(($total_segundos_dia % 3600) / 60),
                $total_segundos_dia % 60
            );
$html .= "<td rowspan=\"$rowspan\" style='background-color: $fondo_dia;'><strong>$total_txt</strong></td>";
        }

        $html .= "</tr>";
    }
}



$html .= "</tbody></table>";
if ($incluir_observaciones) {
    $observaciones = $wpdb->get_results($wpdb->prepare(
        "SELECT fecha_observacion, observaciones 
         FROM {$wpdb->prefix}observaciones 
         WHERE user_id = %d 
         AND fecha_observacion BETWEEN %s AND %s 
         ORDER BY fecha_observacion ASC",
        $trabajador_id, $fecha_inicio, $fecha_fin
    ));

    if ($observaciones) {
        $html .= "<h2 style='margin-top: 30px; color: #333;'>Observaciones</h2><ul style='padding-left: 20px;'>";
        foreach ($observaciones as $obs) {
            $fecha = date('d/m/Y', strtotime($obs->fecha_observacion));
            $texto = htmlspecialchars($obs->observaciones);
            $html .= "<li><strong>$fecha:</strong> $texto</li>";
        }
        $html .= "</ul>";
    }
}


} else {
    $html .= "<p style='text-align:center; margin-top:40px;'>No hay registros de fichaje en este periodo.</p>";
}



    // Generar PDF
    $dompdf = new Dompdf();
    $dompdf->loadHtml($html);
    $dompdf->setPaper('A4', 'portrait');
    $dompdf->render();
    $dompdf->stream("fichajes-$nombre.pdf", ['Attachment' => 0]); // Attachment: 0 = mostrar, 1 = descargar

    exit;
}


//////////GEnerar pdf SEPA

add_action('admin_post_generar_pdf_sepa', 'pluggin_generar_pdf_sepa');
add_action('admin_post_nopriv_generar_pdf_sepa', 'pluggin_generar_pdf_sepa');

function pluggin_generar_pdf_sepa() {
    if (!isset($_GET['cif'])) {
        wp_die('❌ Falta el CIF.');
    }

    global $wpdb;

    $user_id = get_current_user_id();
    if (!$user_id) {
        wp_die('❌ Debes iniciar sesión.');
    }

    $cif = sanitize_text_field($_GET['cif']);
    $tabla_empresas = $wpdb->prefix . 'empresas';

    $empresa = $wpdb->get_row($wpdb->prepare(
        "SELECT * FROM $tabla_empresas WHERE user_id = %d AND user_cif = %s",
        $user_id, $cif
    ));

    if (!$empresa) {
        wp_die('❌ No se encontró la empresa para el usuario.');
    }

    // Contenido HTML del mandato
    $html = "<style>
        body { font-family: Arial, sans-serif; font-size: 13px; }
        h1 { text-align: center; color: #0073aa; }
        .bloque { margin-top: 20px; }
        .bloque strong { color: #333; }
    </style>";

    $html .= "<h1>Mandato SEPA - Autorización de Domiciliación Bancaria</h1>";

    $html .= "<div class='bloque'><strong>CIF:</strong> {$empresa->user_cif}</div>";
    $html .= "<div class='bloque'><strong>Razón Social:</strong> {$empresa->razon_social}</div>";
    $html .= "<div class='bloque'><strong>Dirección de Facturación:</strong><br>" . nl2br($empresa->direccion_facturacion) . "</div>";
    $html .= "<div class='bloque'><strong>Método de Pago:</strong> {$empresa->metodo_pago}</div>";
    $html .= "<div class='bloque'><strong>Fecha de Aceptación:</strong> {$empresa->fecha_aceptacion}</div>";
    $html .= "<div class='bloque'><strong>IP de Firma:</strong> {$empresa->ip_firma}</div>";
    $html .= "<div class='bloque'><strong>Navegador/Dispositivo:</strong><br>" . htmlspecialchars($empresa->user_agent) . "</div>";

    $html .= "<div class='bloque' style='margin-top:30px;'>Este documento acredita la aceptación voluntaria de las condiciones de domiciliación bancaria conforme a la normativa SEPA y será almacenado electrónicamente como prueba de conformidad.</div>";

    $dompdf = new Dompdf();
    $dompdf->loadHtml($html);
    $dompdf->setPaper('A4', 'portrait');
    $dompdf->render();
    $dompdf->stream("mandato-SEPA-{$empresa->user_cif}.pdf", ['Attachment' => 1]);

    exit;
}


add_action('admin_post_generar_pdf_todos_trabajadores', 'pluggin_generar_pdf_todos_trabajadores');
add_action('admin_post_nopriv_generar_pdf_todos_trabajadores', 'pluggin_generar_pdf_todos_trabajadores');

function pluggin_generar_pdf_todos_trabajadores() {
    if (!isset($_POST['pdf_cif'], $_POST['pdf_fecha_inicio'], $_POST['pdf_fecha_fin'])) {
        wp_die('❌ Faltan datos para generar el PDF.');
    }

    if (!is_user_logged_in()) {
        wp_die('❌ Debes iniciar sesión.');
    }

    global $wpdb;

    $cif = sanitize_text_field($_POST['pdf_cif']);
    $fecha_inicio = sanitize_text_field($_POST['pdf_fecha_inicio']);
    $fecha_fin = sanitize_text_field($_POST['pdf_fecha_fin']);

    // Obtener todos los usuarios activos (gestores y trabajadores) con ese CIF
    $usuarios = $wpdb->get_results($wpdb->prepare(
        "SELECT ID, display_name, user_rol, user_dni
        FROM {$wpdb->prefix}users 
        WHERE user_cif = %s AND user_estado = 'Activado' AND user_rol IN ('Gestor', 'Trabajador') 
        ORDER BY display_name ASC",
        $cif
    ));


    if (!$usuarios) {
        wp_die('❌ No hay trabajadores ni gestores activos con ese CIF.');
    }

    // Construcción del HTML del PDF
    $html = "<style>
        body { font-family: Arial, sans-serif; font-size: 12px; }
        h1 { text-align: center; color: #0073aa; }
        table { width: 100%; border-collapse: collapse; margin-top: 20px; }
        th, td { padding: 8px; border: 1px solid #ccc; text-align: center; }
        th { background-color: #0073aa; color: white; }
    </style>";

    $html .= "<h1>Resumen de Horas - Empresa CIF: $cif</h1>";
    $html .= "<p><strong>Desde:</strong> " . date('d-m-Y', strtotime($fecha_inicio)) . 
             " &nbsp;&nbsp; <strong>Hasta:</strong> " . date('d-m-Y', strtotime($fecha_fin)) . "</p>";

    $html .= "<table>
    <thead>
        <tr>
            <th>Nombre</th>
            <th>Horas Totales</th>
        </tr>
    </thead>
    <tbody>";


    foreach ($usuarios as $usuario) {
   $segundos = $wpdb->get_var($wpdb->prepare(
    "SELECT SUM(TIME_TO_SEC(tiempo_totalR)) 
     FROM {$wpdb->prefix}registro_horario 
     WHERE user_id = %d AND DATE(entradaR) BETWEEN %s AND %s",
    $usuario->ID, $fecha_inicio, $fecha_fin
));
$segundos = intval($segundos);
$horas = sprintf('%02d:%02d:%02d',
    floor($segundos / 3600),
    floor(($segundos % 3600) / 60),
    $segundos % 60
);
$nombre = esc_html($usuario->display_name);

$html .= "<tr>
    <td>{$nombre}</td>
    <td>{$horas}</td>
</tr>";

}


    $html .= "</tbody></table>";

    // Generar PDF
    $dompdf = new Dompdf();
    $dompdf->loadHtml($html);
    $dompdf->setPaper('A4', 'portrait');
    $dompdf->render();
    $dompdf->stream("resumen_trabajadores_$cif.pdf", ['Attachment' => 0]);

    exit;
}


add_action('admin_post_generar_pdf_detallado_todos_trabajadores', 'pluggin_generar_pdf_detallado_todos_trabajadores');
add_action('admin_post_nopriv_generar_pdf_detallado_todos_trabajadores', 'pluggin_generar_pdf_detallado_todos_trabajadores');

function pluggin_generar_pdf_detallado_todos_trabajadores() {
    if (!isset($_POST['pdf_cif'], $_POST['pdf_fecha_inicio'], $_POST['pdf_fecha_fin'])) {
        wp_die('❌ Faltan datos.');
    }

    if (!is_user_logged_in()) {
        wp_die('❌ Debes iniciar sesión.');
    }

    global $wpdb;

    $cif = sanitize_text_field($_POST['pdf_cif']);
    $fecha_inicio = sanitize_text_field($_POST['pdf_fecha_inicio']);
    $fecha_fin = sanitize_text_field($_POST['pdf_fecha_fin']);
    $incluir_observaciones = isset($_POST['incluir_observaciones']) && $_POST['incluir_observaciones'] == '1';

    $titulo = "<h1>Informe Detallado - CIF: $cif</h1>";
    $fechas = "<p><strong>Desde:</strong> " . date('d-m-Y', strtotime($fecha_inicio)) .
            " &nbsp;&nbsp; <strong>Hasta:</strong> " . date('d-m-Y', strtotime($fecha_fin)) . "</p>";


        $usuarios = $wpdb->get_results($wpdb->prepare(
        "SELECT ID, display_name, user_rol, user_dni
        FROM {$wpdb->prefix}users 
        WHERE user_cif = %s AND user_estado = 'Activado' AND user_rol IN ('Gestor', 'Trabajador') 
        ORDER BY display_name ASC",
        $cif
    ));


    if (!$usuarios) {
        wp_die('❌ No hay trabajadores ni gestores activos.');
    }

    // Estilo HTML común
    $html = "<style>
        body { font-family: Arial, sans-serif; font-size: 12px; }
        h1, h2 { text-align: center; color: #0073aa; }
        h2 { margin-top: 40px; border-top: 1px solid #ccc; padding-top: 20px; }
        table { width: 100%; border-collapse: collapse; margin-top: 15px; }
        th, td { padding: 6px; border: 1px solid #ccc; text-align: center; }
        th { background-color: #0073aa; color: white; }
    </style>";

    $html .= $titulo . $fechas;


    $primero = true;

foreach ($usuarios as $usuario) {
    $user_id = $usuario->ID;
    $dni = trim((string)($usuario->user_dni ?? ''));
    $dni_mostrar = $dni !== '' ? $dni : 'sin DNI';
    $nombre = esc_html($usuario->display_name . ' (' . $dni_mostrar . ')');
    $rol = ucfirst(strtolower($usuario->user_rol));

    if (!$primero) {
        $html .= '<div style="page-break-before: always;"></div>';
        $html .= $titulo . $fechas;
    } else {
        $primero = false;
    }


    // Obtener registros...


        // Obtener registros
        $registros = $wpdb->get_results($wpdb->prepare(
            "SELECT entradaR, salidaR, tiempo_totalR 
             FROM {$wpdb->prefix}registro_horario 
             WHERE user_id = %d 
             AND DATE(entradaR) BETWEEN %s AND %s 
             ORDER BY entradaR DESC",
            $user_id, $fecha_inicio, $fecha_fin
        ));

$html .= "<h2>$nombre <span style='font-size: 10px;'>($rol)</span></h2>";
        if ($registros) {
            $html .= "<table>
                <thead><tr>
                    <th>Entrada</th><th>Salida</th><th>Tiempo</th><th>Total día</th>
                </tr></thead><tbody>";

            $registros_por_dia = [];

            foreach ($registros as $registro) {
                if (!$registro->entradaR) continue;
                $fecha = date('Y-m-d', strtotime($registro->entradaR));
                $registros_por_dia[$fecha][] = $registro;
            }

            krsort($registros_por_dia);
            $alternar = false;

            foreach ($registros_por_dia as $fecha => $registros_dia) {
                $rowspan = count($registros_dia);
                $alternar = !$alternar;
                $bg = $alternar ? '#f9f9f9' : '#ffffff';

                $total_segundos = 0;
                foreach ($registros_dia as $r) {
                    if ($r->entradaR && $r->salidaR) {
                        $inicio = strtotime($r->entradaR);
                        $fin = strtotime($r->salidaR);
                        if ($fin > $inicio) $total_segundos += ($fin - $inicio);
                    }
                }

                foreach ($registros_dia as $i => $r) {
                    $entrada = $r->entradaR ? date('d/m/Y H:i', strtotime($r->entradaR)) : '—';
                    $salida  = $r->salidaR  ? date('d/m/Y H:i', strtotime($r->salidaR)) : 'Falta salida';

                    $tiempo = '00:00:00';
                    if ($r->entradaR && $r->salidaR) {
                        $secs = strtotime($r->salidaR) - strtotime($r->entradaR);
                        $tiempo = sprintf('%02d:%02d:%02d', floor($secs / 3600), floor(($secs % 3600) / 60), $secs % 60);
                    }

                    $html .= "<tr>
                        <td style='background-color:$bg;'>$entrada</td>
                        <td style='background-color:$bg;'>$salida</td>
                        <td style='background-color:$bg;'>$tiempo</td>";

                    if ($i === 0) {
                        $total_txt = sprintf('%02d:%02d:%02d',
                            floor($total_segundos / 3600),
                            floor(($total_segundos % 3600) / 60),
                            $total_segundos % 60
                        );
                        $html .= "<td rowspan=\"$rowspan\" style='background-color:$bg;'><strong>$total_txt</strong></td>";
                    }

                    $html .= "</tr>";
                }
            }

            $html .= "</tbody></table>";

            // Observaciones
            if ($incluir_observaciones) {
                $observaciones = $wpdb->get_results($wpdb->prepare(
                    "SELECT fecha_observacion, observaciones 
                     FROM {$wpdb->prefix}observaciones 
                     WHERE user_id = %d 
                     AND fecha_observacion BETWEEN %s AND %s 
                     ORDER BY fecha_observacion ASC",
                    $user_id, $fecha_inicio, $fecha_fin
                ));

                if ($observaciones) {
                    $html .= "<h3 style='margin-top:20px;'>📝 Observaciones</h3><ul>";
                    foreach ($observaciones as $obs) {
                        $fecha_obs = date('d/m/Y', strtotime($obs->fecha_observacion));
                        $html .= "<li><strong>$fecha_obs:</strong> " . esc_html($obs->observaciones) . "</li>";
                    }
                    $html .= "</ul>";
                }
            }

        } else {
            $html .= "<p style='text-align:center;'>No hay registros en este periodo.</p>";
        }
    }

    // Generar PDF
    $dompdf = new Dompdf();
    $dompdf->loadHtml($html);
    $dompdf->setPaper('A4', 'portrait');
    $dompdf->render();
    $dompdf->stream("detallado_trabajadores_$cif.pdf", ['Attachment' => 0]);

    exit;
}


// ======================================================
//  INFORME GLOBAL POR LUGARES (detalle por persona y día)
//  action: generar_pdf_lugares_empresa
// ======================================================
add_action('admin_post_generar_pdf_lugares_empresa', 'pluggin_generar_pdf_lugares_empresa');
add_action('admin_post_nopriv_generar_pdf_lugares_empresa', 'pluggin_generar_pdf_lugares_empresa');

function pluggin_generar_pdf_lugares_empresa() {
    if (!isset($_POST['pdf_cif'], $_POST['pdf_fecha_inicio'], $_POST['pdf_fecha_fin'])) {
        wp_die('❌ Faltan datos para generar el informe por lugares.');
    }

    if (!is_user_logged_in()) {
        wp_die('❌ Debes iniciar sesión.');
    }

    global $wpdb;

    $cif          = sanitize_text_field($_POST['pdf_cif']);
    $fecha_inicio = sanitize_text_field($_POST['pdf_fecha_inicio']);
    $fecha_fin    = sanitize_text_field($_POST['pdf_fecha_fin']);

    $fecha_inicio_sql = date('Y-m-d', strtotime($fecha_inicio));
    $fecha_fin_sql    = date('Y-m-d', strtotime($fecha_fin));

    $empresa_nombre = $wpdb->get_var($wpdb->prepare(
        "SELECT razon_social FROM {$wpdb->prefix}empresas WHERE user_cif = %s",
        $cif
    ));
    if (!$empresa_nombre) {
        $empresa_nombre = 'Empresa sin nombre';
    }

    $tabla_registro = $wpdb->prefix . 'registro_horario';
    $tabla_lugares  = $wpdb->prefix . 'lugares';
    $tabla_users    = $wpdb->prefix . 'users';

    // Sacar lista de lugares que tienen fichajes en el periodo
    $lugares = $wpdb->get_results($wpdb->prepare(
        "SELECT 
            rh.lugar_id,
            COALESCE(l.nombre_lugar, 'Sin lugar asignado') AS nombre_lugar
         FROM $tabla_registro rh
         LEFT JOIN $tabla_lugares l ON rh.lugar_id = l.id
         WHERE rh.cif_usuario = %s
           AND DATE(rh.entradaR) BETWEEN %s AND %s
         GROUP BY rh.lugar_id, l.nombre_lugar
         ORDER BY nombre_lugar ASC",
        $cif,
        $fecha_inicio_sql,
        $fecha_fin_sql
    ));

    if (empty($lugares)) {
        wp_die('No hay registros en ese periodo para generar el informe por lugares.');
    }

    // ===== Estilos generales =====
    $html = "<style>
        body { font-family: Arial, sans-serif; font-size: 11px; }
        h1 { text-align: center; color: #0073aa; }
        h2 { text-align: left; color: #333; margin-top: 10px; }
        p  { margin: 4px 0; }
        table { width: 100%; border-collapse: collapse; margin-top: 10px; }
        th, td { padding: 5px; border: 1px solid #ccc; text-align: center; }
        th { background-color: #0073aa; color: white; }
        .totales-lugar { margin-top: 8px; font-weight: bold; }
        .page-break { page-break-before: always; }
    </style>";

    $primero = true;

    foreach ($lugares as $lugar) {
        $lugar_id      = $lugar->lugar_id;
        $nombre_lugar  = $lugar->nombre_lugar ?: 'Sin lugar asignado';

        // Saltos de página: cada lugar en una hoja
        if ($primero) {
            $primero = false;
        } else {
            $html .= '<div class="page-break"></div>';
        }

        // Título de lugar
        $html .= "<h1>Informe por lugar de trabajo</h1>";
        $html .= "<p><strong>Empresa:</strong> " . esc_html($empresa_nombre) . " ($cif)</p>";
        $html .= "<p><strong>Lugar:</strong> " . esc_html($nombre_lugar) . "</p>";
        $html .= "<p><strong>Desde:</strong> " . date('d-m-Y', strtotime($fecha_inicio_sql)) .
                 " &nbsp;&nbsp; <strong>Hasta:</strong> " . date('d-m-Y', strtotime($fecha_fin_sql)) . "</p>";

        // Registros de este lugar
        if ($lugar_id === null) {
            // Registros sin lugar asignado (null o 0)
            $registros = $wpdb->get_results($wpdb->prepare(
                "SELECT rh.*, u.display_name, u.user_dni
                 FROM $tabla_registro rh
                 LEFT JOIN $tabla_users u ON rh.user_id = u.ID
                 WHERE rh.cif_usuario = %s
                   AND DATE(rh.entradaR) BETWEEN %s AND %s
                   AND (rh.lugar_id IS NULL OR rh.lugar_id = 0)
                 ORDER BY rh.entradaR ASC",
                $cif,
                $fecha_inicio_sql,
                $fecha_fin_sql
            ));
        } else {
            $registros = $wpdb->get_results($wpdb->prepare(
                "SELECT rh.*, u.display_name, u.user_dni
                 FROM $tabla_registro rh
                 LEFT JOIN $tabla_users u ON rh.user_id = u.ID
                 WHERE rh.cif_usuario = %s
                   AND DATE(rh.entradaR) BETWEEN %s AND %s
                   AND rh.lugar_id = %d
                 ORDER BY rh.entradaR ASC",
                $cif,
                $fecha_inicio_sql,
                $fecha_fin_sql,
                $lugar_id
            ));
        }

        if (empty($registros)) {
            $html .= "<p style='margin-top:20px; text-align:center;'>No hay registros para este lugar en el periodo indicado.</p>";
            continue;
        }

        // Agrupar por día
        $registros_por_dia = [];
        foreach ($registros as $r) {
            if (empty($r->entradaR)) continue;
            $fecha = date('Y-m-d', strtotime($r->entradaR));
            $registros_por_dia[$fecha][] = $r;
        }
        ksort($registros_por_dia); // orden cronológico

        $html .= "<table>
            <thead>
                <tr>
                    <th>Día</th>
                    <th>Persona</th>
                    <th>Entrada</th>
                    <th>Salida</th>
                    <th>Tiempo</th>
                    <th>Total día</th>
                </tr>
            </thead>
            <tbody>";

        $total_segundos_lugar = 0;

        foreach ($registros_por_dia as $fecha => $regs_dia) {
            $rowspan = count($regs_dia);

            // Calcular total día
            $total_segundos_dia = 0;
            foreach ($regs_dia as $r) {
                if ($r->entradaR && $r->salidaR) {
                    $ini = strtotime($r->entradaR);
                    $fin = strtotime($r->salidaR);
                    if ($fin > $ini) {
                        $total_segundos_dia += ($fin - $ini);
                    }
                }
            }
            $total_segundos_lugar += $total_segundos_dia;

            $total_dia_txt = sprintf('%02d:%02d:%02d',
                floor($total_segundos_dia / 3600),
                floor(($total_segundos_dia % 3600) / 60),
                $total_segundos_dia % 60
            );

            $primera_fila_dia = true;

            foreach ($regs_dia as $r) {
                $nombre_user = $r->display_name ?: 'Sin nombre';
                $dni_raw     = trim((string)($r->user_dni ?? ''));
                $dni_mostrar = $dni_raw !== '' ? $dni_raw : 'sin DNI';
                $persona_txt = esc_html($nombre_user . ' (' . $dni_mostrar . ')');

                $entrada_hora = $r->entradaR ? date('H:i', strtotime($r->entradaR)) : '—';
                $salida_hora  = $r->salidaR  ? date('H:i', strtotime($r->salidaR)) : 'Falta salida';

                // Tiempo de ese registro
                $tiempo_txt = '00:00:00';
                if ($r->entradaR && $r->salidaR) {
                    $ini = strtotime($r->entradaR);
                    $fin = strtotime($r->salidaR);
                    if ($fin > $ini) {
                        $seg = $fin - $ini;
                        $tiempo_txt = sprintf('%02d:%02d:%02d',
                            floor($seg / 3600),
                            floor(($seg % 3600) / 60),
                            $seg % 60
                        );
                    }
                }

                $html .= "<tr>";

                // Día solo en la primera fila de ese día
                if ($primera_fila_dia) {
                    $html .= "<td rowspan=\"$rowspan\">" . date('d/m/Y', strtotime($fecha)) . "</td>";
                    $primera_fila_dia = false;
                }

                $html .= "
                    <td>$persona_txt</td>
                    <td>$entrada_hora</td>
                    <td>$salida_hora</td>
                    <td>$tiempo_txt</td>";

                // Total día también solo en la primera fila
                if ($rowspan > 0 && !$primera_fila_dia) {
                    // primera fila ya consumida, pero esto se ejecuta en todas; sólo cuando era la primera añadimos:
                    // truco: detectar si es la primera iteración por día comparando un flag antes de cambiarlo
                }

                // Para resolver el tema del total día: añadimos en la fila donde hemos pintado el día
                // Lo fácil: si la celda de día ya está impresa, imprimimos también el total
                // (lo sabemos porque acabamos de poner $primera_fila_dia = false arriba, así que aquí:
                // si ( ! $primera_fila_dia ) y es la primera iteración -> total día.
                static $contador_interno = 0; // no usado realmente, pero lo dejo por claridad
                if ($rowspan > 0 && $tiempo_txt !== null) {
                    // Para que solo salga en la primera fila de ese día, comprobamos que el número de celdas
                    // de 'Total día' no se haya generado aún; lo controlamos con otra bandera
                }

                // Versión simple: rellenamos en todas, pero con rowspan:
                // lo hacemos calculando fuera.
                // Mejor: reescribimos un poco:
                // (para no liarnos aquí, lo hacemos en otra pasada)
                $html .= "</tr>";
            }

            // Truco rápido: añadimos una fila extra solo con el total del día
            $html .= "<tr>
                <td colspan=\"5\" style=\"text-align:right; font-weight:bold;\">Total día " . date('d/m/Y', strtotime($fecha)) . ":</td>
                <td><strong>$total_dia_txt</strong></td>
            </tr>";
        }

        // Total del lugar
        $seg = $total_segundos_lugar;
        $horas_l   = floor($seg / 3600);
        $min_l     = floor(($seg % 3600) / 60);
        $seg_l     = $seg % 60;
        $total_lugar_txt = sprintf('%02d:%02d:%02d', $horas_l, $min_l, $seg_l);

        $html .= "</tbody></table>";
        $html .= "<p class='totales-lugar'>Total tiempo en este lugar (periodo seleccionado): $total_lugar_txt</p>";
    }

    // Generar PDF
    $dompdf = new Dompdf();
    $dompdf->loadHtml($html);
    $dompdf->setPaper('A4', 'portrait');
    $dompdf->render();

    $nombre_fichero = "informe_lugares_detalle_{$cif}_{$fecha_inicio_sql}_{$fecha_fin_sql}.pdf";
    $dompdf->stream($nombre_fichero, ['Attachment' => 0]);

    exit;
}


// ======================================================
//  INFORME TRABAJADOR + LUGARES
//  action: generar_pdf_trabajador_lugares
// ======================================================
add_action('admin_post_generar_pdf_trabajador_lugares', 'pluggin_generar_pdf_trabajador_lugares');
add_action('admin_post_nopriv_generar_pdf_trabajador_lugares', 'pluggin_generar_pdf_trabajador_lugares');

function pluggin_generar_pdf_trabajador_lugares() {
    if (!isset($_POST['pdf_trabajador_id'], $_POST['pdf_cif'], $_POST['pdf_fecha_inicio'], $_POST['pdf_fecha_fin'])) {
        wp_die('❌ Faltan datos para generar el informe del trabajador por lugares.');
    }

    if (!is_user_logged_in()) {
        wp_die('❌ Debes iniciar sesión.');
    }

    global $wpdb;

    $trabajador_id = intval($_POST['pdf_trabajador_id']);
    $cif           = sanitize_text_field($_POST['pdf_cif']);
    $fecha_inicio  = sanitize_text_field($_POST['pdf_fecha_inicio']);
    $fecha_fin     = sanitize_text_field($_POST['pdf_fecha_fin']);

    $fecha_inicio_sql = date('Y-m-d', strtotime($fecha_inicio));
    $fecha_fin_sql    = date('Y-m-d', strtotime($fecha_fin));

    // Datos del trabajador
    $usuario = get_userdata($trabajador_id);
    if (!$usuario) {
        wp_die('❌ Trabajador no encontrado.');
    }
    $dni_raw     = trim((string)($usuario->user_dni ?? ''));
    $dni_mostrar = $dni_raw !== '' ? $dni_raw : 'sin DNI';
    $nombre_trab = esc_html($usuario->display_name . ' (' . $dni_mostrar . ')');

    // Nombre de la empresa
    $empresa_nombre = $wpdb->get_var($wpdb->prepare(
        "SELECT razon_social FROM {$wpdb->prefix}empresas WHERE user_cif = %s",
        $cif
    ));
    if (!$empresa_nombre) {
        $empresa_nombre = 'Empresa sin nombre';
    }

    $tabla_registro = $wpdb->prefix . 'registro_horario';
    $tabla_lugares  = $wpdb->prefix . 'lugares';

    // Registros del trabajador, con lugar
    $registros = $wpdb->get_results($wpdb->prepare(
        "SELECT rh.*, COALESCE(l.nombre_lugar, 'Sin lugar asignado') AS nombre_lugar
         FROM $tabla_registro rh
         LEFT JOIN $tabla_lugares l ON rh.lugar_id = l.id
         WHERE rh.user_id = %d
           AND rh.cif_usuario = %s
           AND DATE(rh.entradaR) BETWEEN %s AND %s
         ORDER BY nombre_lugar ASC, rh.entradaR ASC",
        $trabajador_id,
        $cif,
        $fecha_inicio_sql,
        $fecha_fin_sql
    ));

    if (empty($registros)) {
        wp_die('No hay registros de este trabajador en el periodo indicado.');
    }

    // Agrupar por lugar
    $por_lugar = [];
    foreach ($registros as $r) {
        $nombre_lugar = $r->nombre_lugar ?: 'Sin lugar asignado';
        if (!isset($por_lugar[$nombre_lugar])) {
            $por_lugar[$nombre_lugar] = [];
        }
        $por_lugar[$nombre_lugar][] = $r;
    }

    // ===== Estilos generales =====
    $html = "<style>
        body { font-family: Arial, sans-serif; font-size: 11px; }
        h1 { text-align: center; color: #0073aa; }
        h2 { text-align: left; color: #333; margin-top: 15px; }
        p  { margin: 4px 0; }
        table { width: 100%; border-collapse: collapse; margin-top: 8px; }
        th, td { padding: 5px; border: 1px solid #ccc; text-align: center; }
        th { background-color: #0073aa; color: white; }
        .totales-lugar { margin-top: 8px; font-weight: bold; }
        .totales-global { margin-top: 15px; font-weight: bold; text-align:right; }
        .page-break { page-break-before: always; }
    </style>";

    $html .= "<h1>Informe de fichajes por lugares</h1>";
    $html .= "<p><strong>Empresa:</strong> " . esc_html($empresa_nombre) . " ($cif)</p>";
    $html .= "<p><strong>Trabajador:</strong> $nombre_trab</p>";
    $html .= "<p><strong>Desde:</strong> " . date('d-m-Y', strtotime($fecha_inicio_sql)) .
             " &nbsp;&nbsp; <strong>Hasta:</strong> " . date('d-m-Y', strtotime($fecha_fin_sql)) . "</p>";

    $primero_lugar = true;
    $total_segundos_trabajador = 0;

    foreach ($por_lugar as $nombre_lugar => $regs_lugar) {

        // Cada lugar a partir del segundo, en nueva página
        if ($primero_lugar) {
            $primero_lugar = false;
        } else {
            $html .= '<div class="page-break"></div>';
            // Repetimos cabecera ligera para contextualizar en nuevas páginas
            $html .= "<h1>Informe de fichajes por lugares</h1>";
            $html .= "<p><strong>Empresa:</strong> " . esc_html($empresa_nombre) . " ($cif)</p>";
            $html .= "<p><strong>Trabajador:</strong> $nombre_trab</p>";
            $html .= "<p><strong>Desde:</strong> " . date('d-m-Y', strtotime($fecha_inicio_sql)) .
                     " &nbsp;&nbsp; <strong>Hasta:</strong> " . date('d-m-Y', strtotime($fecha_fin_sql)) . "</p>";
        }

        $html .= "<h2>Lugar: " . esc_html($nombre_lugar) . "</h2>";

        // Agrupar por día dentro de este lugar
        $regs_por_dia = [];
        foreach ($regs_lugar as $r) {
            if (empty($r->entradaR)) continue;
            $fecha = date('Y-m-d', strtotime($r->entradaR));
            $regs_por_dia[$fecha][] = $r;
        }
        ksort($regs_por_dia);

        if (empty($regs_por_dia)) {
            $html .= "<p style='margin-top:10px;'>No hay registros válidos en este lugar.</p>";
            continue;
        }

        $html .= "<table>
            <thead>
                <tr>
                    <th>Día</th>
                    <th>Entrada</th>
                    <th>Salida</th>
                    <th>Tiempo</th>
                    <th>Total día</th>
                </tr>
            </thead>
            <tbody>";

        $total_segundos_lugar = 0;

        foreach ($regs_por_dia as $fecha => $regs_dia) {

            // Total del día
            $total_segundos_dia = 0;
            foreach ($regs_dia as $r) {
                if ($r->entradaR && $r->salidaR) {
                    $ini = strtotime($r->entradaR);
                    $fin = strtotime($r->salidaR);
                    if ($fin > $ini) {
                        $total_segundos_dia += ($fin - $ini);
                    }
                }
            }
            $total_segundos_lugar      += $total_segundos_dia;
            $total_segundos_trabajador += $total_segundos_dia;

            $total_dia_txt = sprintf('%02d:%02d:%02d',
                floor($total_segundos_dia / 3600),
                floor(($total_segundos_dia % 3600) / 60),
                $total_segundos_dia % 60
            );

            // Filas del día
            foreach ($regs_dia as $idx => $r) {
                $entrada_hora = $r->entradaR ? date('H:i', strtotime($r->entradaR)) : '—';
                $salida_hora  = $r->salidaR  ? date('H:i', strtotime($r->salidaR)) : 'Falta salida';

                $tiempo_txt = '00:00:00';
                if ($r->entradaR && $r->salidaR) {
                    $ini = strtotime($r->entradaR);
                    $fin = strtotime($r->salidaR);
                    if ($fin > $ini) {
                        $seg = $fin - $ini;
                        $tiempo_txt = sprintf('%02d:%02d:%02d',
                            floor($seg / 3600),
                            floor(($seg % 3600) / 60),
                            $seg % 60
                        );
                    }
                }

                $html .= "<tr>";
                // Día en la primera fila
                if ($idx === 0) {
                    $html .= "<td rowspan=\"" . count($regs_dia) . "\">" . date('d/m/Y', strtotime($fecha)) . "</td>";
                }
                $html .= "
                    <td>$entrada_hora</td>
                    <td>$salida_hora</td>
                    <td>$tiempo_txt</td>";

                // En vez de meter el total día con rowspan, sacamos una fila resumen al final del día:
                $html .= "<td></td>";
                $html .= "</tr>";
            }

            // Fila resumen del día
            $html .= "<tr>
                <td colspan=\"4\" style=\"text-align:right; font-weight:bold;\">Total día " . date('d/m/Y', strtotime($fecha)) . ":</td>
                <td><strong>$total_dia_txt</strong></td>
            </tr>";
        }

        // Total por lugar
        $seg = $total_segundos_lugar;
        $hor_l = floor($seg / 3600);
        $min_l = floor(($seg % 3600) / 60);
        $seg_l = $seg % 60;
        $total_lugar_txt = sprintf('%02d:%02d:%02d', $hor_l, $min_l, $seg_l);

        $html .= "</tbody></table>";
        $html .= "<p class='totales-lugar'>Total tiempo del trabajador en este lugar (periodo seleccionado): $total_lugar_txt</p>";
    }

    // Total global del trabajador (todos los lugares)
    $segT = $total_segundos_trabajador;
    $hT   = floor($segT / 3600);
    $mT   = floor(($segT % 3600) / 60);
    $sT   = $segT % 60;
    $total_trabajador_txt = sprintf('%02d:%02d:%02d', $hT, $mT, $sT);

    $html .= "<p class='totales-global'>Total global del trabajador en el periodo: $total_trabajador_txt</p>";

    // Generar PDF
    $dompdf = new Dompdf();
    $dompdf->loadHtml($html);
    $dompdf->setPaper('A4', 'portrait');
    $dompdf->render();

    $nombre_fichero = "trabajador_lugares_{$trabajador_id}_{$fecha_inicio_sql}_{$fecha_fin_sql}.pdf";
    $dompdf->stream($nombre_fichero, ['Attachment' => 0]);

    exit;
}
