<?php
if (!defined('ABSPATH')) exit;

global $wpdb;

$mensaje = '';
$tabla_mnkt = $wpdb->prefix . 'users';
$tabla_empresas = $wpdb->prefix . 'empresas';
$tabla_empresas_usuarios = $wpdb->prefix . 'empresas_usuarios';



/// Acción de actualizar usuario 

// Editar trabajador
if (isset($_POST['guardar_trabajador'])) {
    $user_id = intval($_POST['user_id']);
    $nombre = sanitize_text_field($_POST['nombre']);
    $email = sanitize_email($_POST['email']);
    $dni = sanitize_text_field($_POST['dni']);
    $cif = sanitize_text_field($_POST['user_cif']);
    $password = sanitize_text_field($_POST['user_pass'] ?? '');

    // Obtener empresa_id por el CIF seleccionado
$empresa_id = $wpdb->get_var(
    $wpdb->prepare("SELECT id FROM $tabla_empresas WHERE user_cif = %s LIMIT 1", $cif)
);
if (!$empresa_id) {
    $mensaje = "<div class='error'><p>❌ No existe empresa para el CIF <strong>$cif</strong>. Revisa el selector.</p></div>";
    echo $mensaje;
    return;
}


    $args = [
        'ID' => $user_id,
        'user_email' => $email,
        'display_name' => $nombre,
        'user_login' => $nombre,
        'user_nicename' => sanitize_title($nombre)
    ];

    if (!empty($password)) {
        $args['user_pass'] = $password;
    }

    $resultado = wp_update_user($args);

    if (!is_wp_error($resultado)) {
        $wpdb->update($tabla_mnkt, [
    'user_dni'    => $dni,
    'user_cif'    => $cif,
    'user_cif_id' => $empresa_id
], ['ID' => $user_id], ['%s','%s','%d'], ['%d']);

// Reasignar asociación del trabajador a la empresa seleccionada
// (limpiamos asociaciones previas y dejamos solo la nueva)
$wpdb->delete($tabla_empresas_usuarios, ['user_id' => $user_id], ['%d']);

$ok_assoc = $wpdb->insert($tabla_empresas_usuarios, [
    'user_id'        => $user_id,
    'empresa_id'     => $empresa_id,
    'rol_en_empresa' => 'Trabajador',
    'estado'         => 'Activado',
    'creado_en'      => current_time('mysql'),
], ['%d','%d','%s','%s','%s']);

if ($ok_assoc === false) {
    error_log("❌ Error reasignando asociación user_id={$user_id} empresa_id={$empresa_id}: " . $wpdb->last_error);
}

        $mensaje = "<div class='updated'><p>✅ Trabajador actualizado correctamente.</p></div>";
    } else {
        $mensaje = "<div class='error'><p>❌ Error al actualizar trabajador: " . $resultado->get_error_message() . "</p></div>";
    }
}

// Acciones: activar/desactivar, reenviar contraseña




if (isset($_GET['toggle'])) {
    $id = intval($_GET['toggle']);
    $estado_actual = $wpdb->get_var($wpdb->prepare("SELECT user_estado FROM $tabla_mnkt WHERE ID = %d", $id));
    $nuevo_estado = ($estado_actual === 'Activado') ? 'Desactivado' : 'Activado';
    $wpdb->update($tabla_mnkt, ['user_estado' => $nuevo_estado], ['ID' => $id]);
    wp_redirect(remove_query_arg('toggle'));
    exit;
}

if (isset($_GET['reenviar'])) {
    $id = intval($_GET['reenviar']);
    $user = get_userdata($id);
    if ($user) {
        retrieve_password($user->user_login);
        $mensaje = "<div class='updated'><p>📧 Email de recuperación enviado a " . esc_html($user->user_email) . "</p></div>";
    }
}

// Cargar datos del trabajador para edición
$editar_trabajador = null;
if (isset($_GET['editar']) && is_numeric($_GET['editar'])) {
    $editar_trabajador = get_userdata(intval($_GET['editar']));
}


// Filtros
$filtro_cif    = isset($_GET['filtro_cif']) ? sanitize_text_field($_GET['filtro_cif']) : '';
$filtro_estado = isset($_GET['filtro_estado']) ? sanitize_text_field($_GET['filtro_estado']) : '';

$where = "WHERE u.user_rol = 'Trabajador'";
if ($filtro_cif) {
    $where .= $wpdb->prepare(" AND u.user_cif = %s", $filtro_cif);
}
if ($filtro_estado) {
    $where .= $wpdb->prepare(" AND u.user_estado = %s", $filtro_estado);
}


$trabajadores = $wpdb->get_results("
  SELECT 
    u.*,
    e.id            AS empresa_id_ref,
    e.user_cif      AS empresa_cif_por_id,
    e.razon_social  AS empresa_razon_social,
    e.gamificacion  AS empresa_gamificacion,
    CASE 
      WHEN e.id IS NULL THEN 0
      WHEN EXISTS (
        SELECT 1 FROM $tabla_empresas_usuarios eu 
        WHERE eu.user_id = u.ID AND eu.empresa_id = e.id
      ) THEN 1 ELSE 0 
    END AS asociado_empresa
  FROM $tabla_mnkt u
  LEFT JOIN $tabla_empresas e ON e.id = u.user_cif_id
  $where
");

// Lista de empresas para desplegables (filtros, crear, CSV)
$empresas = $wpdb->get_results("
  SELECT id, user_cif, razon_social
  FROM {$wpdb->prefix}empresas
  WHERE user_cif IS NOT NULL AND user_cif <> ''
  ORDER BY razon_social
");



// Obtener todos los CIFs únicos para el formulario
$gestores = $wpdb->get_results("
    SELECT id, user_cif, razon_social
    FROM {$wpdb->prefix}empresas
    WHERE user_cif IS NOT NULL AND user_cif != ''
    ORDER BY razon_social
");

// Función para obtener gamificación desde un CIF
function obtener_gamificacion_por_cif($cif, $wpdb, $tabla_mnkt) {
    return (int) $wpdb->get_var($wpdb->prepare("SELECT user_gamificacion FROM $tabla_mnkt WHERE user_cif = %s AND user_rol = 'Gestor' LIMIT 1", $cif));
}

// Crear trabajador manual
if (isset($_POST['crear_trabajador_manual'])) {
    $nombre = sanitize_text_field($_POST['nombre']);
    $email = sanitize_email($_POST['email']);
    $dni = sanitize_text_field($_POST['dni']);
    $cif = sanitize_text_field($_POST['user_cif']);
    $tabla_empresas = $wpdb->prefix . 'empresas';
$empresa_id = $wpdb->get_var(
    $wpdb->prepare("SELECT id FROM $tabla_empresas WHERE user_cif = %s LIMIT 1", $cif)
);

if (!$empresa_id) {
    $mensaje = "<div class='error'><p>❌ No existe ninguna empresa con el CIF <strong>$cif</strong> en la tabla de empresas. Crea la empresa primero o selecciona otro CIF.</p></div>";
    // Cortamos aquí para no insertar sin user_cif_id
    echo $mensaje;
    return;
}


    if (!filter_var($email, FILTER_VALIDATE_EMAIL) || !preg_match('/^[0-9]{6,8}$/', $dni)) {
        $mensaje = "<div class='error'><p>❌ Email o DNI inválido.</p></div>";
    } else {
        $existe = $wpdb->get_var($wpdb->prepare("SELECT COUNT(*) FROM $tabla_mnkt WHERE user_email = %s", $email));
        if ($existe > 0) {
            $mensaje = "<div class='error'><p>❌ El correo ya existe.</p></div>";
        } else {
            $password = wp_generate_password();
            $hashed_password = wp_hash_password($password);
            $gamificacion = obtener_gamificacion_por_cif($cif, $wpdb, $tabla_mnkt);

            $wpdb->insert($tabla_mnkt, [
                'user_login' => $nombre,
                'user_nicename' => sanitize_title($nombre),
                'user_pass' => $hashed_password,
                'user_email' => $email,
                'display_name' => $nombre,
                'user_dni' => $dni,
                'user_cif' => $cif,
                'user_cif_id'       => $empresa_id, 
                'user_gamificacion' => $gamificacion,
                'user_rol' => 'Trabajador',
                'user_estado' => 'Activado',
                'user_registered' => current_time('mysql')
            ]);
            
            // Obtener el ID del usuario recién creado
$nuevo_user_id = $wpdb->insert_id;

// Seguridad: si por lo que sea no hay user_id, no seguimos
if ($nuevo_user_id) {
    // Evitar duplicados en la asociación
    $ya_existe = (int) $wpdb->get_var(
        $wpdb->prepare(
            "SELECT COUNT(*) FROM $tabla_empresas_usuarios WHERE user_id = %d AND empresa_id = %d",
            $nuevo_user_id,
            $empresa_id
        )
    );

    if ($ya_existe === 0) {
        // Insertar asociación usuario↔empresa
        $ok_assoc = $wpdb->insert($tabla_empresas_usuarios, [
            'user_id'       => $nuevo_user_id,
            'empresa_id'    => $empresa_id,
            'rol_en_empresa'=> 'Trabajador',
            'estado'        => 'Activado',
            'creado_en'     => current_time('mysql'),
        ], ['%d','%d','%s','%s','%s']);

        if ($ok_assoc === false) {
            error_log("❌ Error insertando asociación user_id={$nuevo_user_id} empresa_id={$empresa_id}: " . $wpdb->last_error);
        } else {
            error_log("✅ Asociación creada: user_id={$nuevo_user_id} empresa_id={$empresa_id}");
        }
    } else {
        error_log("ℹ️ Asociación ya existía: user_id={$nuevo_user_id} empresa_id={$empresa_id}");
    }
} else {
    error_log("❌ No se pudo obtener el ID del nuevo usuario tras el insert.");
}


$template_path = plugin_dir_path(dirname(dirname(__FILE__))) . 'templates/email-nuevo-trabajador.html';

// Verifica si la plantilla existe
if (file_exists($template_path)) {
    error_log("✅ Plantilla encontrada en: $template_path");

    $email_body = file_get_contents($template_path);

    // Verifica si la plantilla tiene contenido
    if (empty($email_body)) {
        error_log("❌ La plantilla está vacía.");
    } else {
        // Reemplaza los valores
        $email_body = str_replace(
            ['[user_login]', '[user_email]', '[password]'],
            [$nombre, $email, $password],
            $email_body
        );

        // Mostrar contenido final del email
        error_log("📧 Contenido del email:\n" . $email_body);

        // Envío del correo
        $headers = [
            'Content-Type: text/html; charset=UTF-8',
            'From: E-Digitiall <no-reply@educasede.com>'
        ];

        $enviado = wp_mail($email, 'Bienvenido a E-Digitiall', $email_body, $headers);

        if ($enviado) {
            error_log("✅ Email enviado correctamente a: $email");
        } else {
            error_log("❌ Fallo al enviar el email a: $email");
        }
    }

} else {
    error_log("❌ No se encontró la plantilla en: $template_path");
}


$mensaje = "<div class='updated'><p>✅ Trabajador creado, asociado a la empresa y notificado por email.</p></div>";
        }
    }
}

// Procesar CSV
if (!empty($_FILES['archivo_csv']['tmp_name'])) {
    $insertados = 0;
    $rechazados = 0;
    $trabajadores_insertados = [];
    $trabajadores_rechazados = [];

    $cif = sanitize_text_field($_POST['user_cif_csv']);
    $gamificacion = obtener_gamificacion_por_cif($cif, $wpdb, $tabla_mnkt);

    // 🔎 Tablas auxiliares
    $tabla_empresas = $wpdb->prefix . 'empresas';
    $tabla_empresas_usuarios = $wpdb->prefix . 'empresas_usuarios';

    // Buscar empresa_id por CIF (obligatorio)
    $empresa_id = $wpdb->get_var(
        $wpdb->prepare("SELECT id FROM $tabla_empresas WHERE user_cif = %s LIMIT 1", $cif)
    );

    if (!$empresa_id) {
        $mensaje = "<div class='error'><p>❌ No existe ninguna empresa con el CIF <strong>$cif</strong> en la tabla de empresas. Crea la empresa primero o selecciona otro CIF.</p></div>";
    } else {
        $file = $_FILES['archivo_csv']['tmp_name'];
        if (($handle = fopen($file, 'r')) !== false) {
            $linea = 0;
            while (($data = fgetcsv($handle, 1000, ',')) !== false) {
                $linea++;
                if ($linea === 1 && strtolower(trim($data[0])) === 'nombre') continue;

                // Esperamos columnas: nombre, dni, email
                list($nombre, $dni, $email) = array_map('trim', $data);

                // Validaciones
                if (empty($nombre) || empty($dni) || empty($email)) {
                    $trabajadores_rechazados[] = "$email (faltan campos)";
                    $rechazados++;
                    continue;
                }
                if (!filter_var($email, FILTER_VALIDATE_EMAIL)) {
                    $trabajadores_rechazados[] = "$email (correo inválido)";
                    $rechazados++;
                    continue;
                }
                // Asegura DNI solo números (por si vienen X/Y/Z)
                $dni_numerico = preg_replace('/\D+/', '', $dni);
                if (!preg_match('/^[0-9]{6,8}$/', $dni_numerico)) {
                    $trabajadores_rechazados[] = "$email (DNI inválido)";
                    $rechazados++;
                    continue;
                }

                $existe = $wpdb->get_var($wpdb->prepare("SELECT COUNT(*) FROM $tabla_mnkt WHERE user_email = %s", $email));
                if ($existe > 0) {
                    $trabajadores_rechazados[] = "$email (correo duplicado)";
                    $rechazados++;
                    continue;
                }

                // Insertar trabajador (con user_cif_id)
                $password        = wp_generate_password();
                $hashed_password = wp_hash_password($password);

                $ok_user = $wpdb->insert($tabla_mnkt, [
                    'user_login'        => $nombre,
                    'user_nicename'     => sanitize_title($nombre),
                    'user_pass'         => $hashed_password,
                    'user_email'        => $email,
                    'display_name'      => $nombre,
                    'user_dni'          => $dni_numerico,
                    'user_cif'          => $cif,
                    'user_cif_id'       => $empresa_id,      // 👈 AÑADIDO
                    'user_gamificacion' => $gamificacion,
                    'user_rol'          => 'Trabajador',
                    'user_estado'       => 'Activado',
                    'user_registered'   => current_time('mysql')
                ], ['%s','%s','%s','%s','%s','%s','%s','%d','%d','%s','%s','%s','%s']);

                if ($ok_user === false) {
                    $trabajadores_rechazados[] = "$email (error al insertar usuario: {$wpdb->last_error})";
                    $rechazados++;
                    continue;
                }

                $nuevo_user_id = $wpdb->insert_id;

                // Insertar asociación en empresas_usuarios (evitar duplicado)
                $ya_existe = (int) $wpdb->get_var(
                    $wpdb->prepare(
                        "SELECT COUNT(*) FROM $tabla_empresas_usuarios WHERE user_id = %d AND empresa_id = %d",
                        $nuevo_user_id,
                        $empresa_id
                    )
                );

                if ($ya_existe === 0) {
                    $ok_assoc = $wpdb->insert($tabla_empresas_usuarios, [
                        'user_id'        => $nuevo_user_id,
                        'empresa_id'     => $empresa_id,
                        'rol_en_empresa' => 'Trabajador',
                        'estado'         => 'Activado',
                        'creado_en'      => current_time('mysql'),
                    ], ['%d','%d','%s','%s','%s']);

                    if ($ok_assoc === false) {
                        error_log("❌ Error asociación CSV user_id={$nuevo_user_id} empresa_id={$empresa_id}: " . $wpdb->last_error);
                    }
                }

                // Email de bienvenida (igual que ya tenías)
                $template_path = plugin_dir_path(dirname(dirname(__FILE__))) . 'templates/email-nuevo-trabajador.html';
                if (file_exists($template_path)) {
                    $email_body = file_get_contents($template_path);
                    $email_body = str_replace(
                        ['[user_login]', '[user_email]', '[password]'],
                        [$nombre, $email, $password],
                        $email_body
                    );

                    wp_mail($email, 'Bienvenido a E-Digitiall', $email_body, [
                        'Content-Type: text/html; charset=UTF-8',
                        'From: E-Digitiall <no-reply@educasede.com>'
                    ]);
                }

                $trabajadores_insertados[] = "$nombre ($email)";
                $insertados++;
            }

            fclose($handle);

            // Mensaje final
            $mensaje  = "<div class='updated'><p>✅ CSV procesado correctamente.<br>";
            $mensaje .= "Se han añadido <strong>$insertados</strong> trabajadores y asociado a la empresa.<br>";
            if (!empty($trabajadores_insertados)) {
                $mensaje .= "<ul><strong>Insertados:</strong>";
                foreach ($trabajadores_insertados as $item) {
                    $mensaje .= "<li>✔️ $item</li>";
                }
                $mensaje .= "</ul>";
            }
            if (!empty($trabajadores_rechazados)) {
                $mensaje .= "<ul><strong>Rechazados:</strong>";
                foreach ($trabajadores_rechazados as $item) {
                    $mensaje .= "<li>❌ $item</li>";
                }
                $mensaje .= "</ul>";
            }
            $mensaje .= "</p></div>";
        }
    }
}


?>

<div class="wrap">
<h1>Trabajadores</h1>
<?php echo $mensaje; ?>
<?php if ($editar_trabajador): ?>
    <h2>Editar Trabajador</h2>
    <form method="post">
        <input type="hidden" name="user_id" value="<?php echo esc_attr($editar_trabajador->ID); ?>">
        <table class="form-table">
            <tr><th><label>Nombre:</label></th>
                <td><input type="text" name="nombre" class="regular-text" value="<?php echo esc_attr($editar_trabajador->display_name); ?>" required></td></tr>
            <tr><th><label>Email:</label></th>
                <td><input type="email" name="email" class="regular-text" value="<?php echo esc_attr($editar_trabajador->user_email); ?>" required></td></tr>
            <tr><th><label>DNI:</label></th>
                <td><input type="text" name="dni" class="regular-text" value="<?php echo esc_attr($editar_trabajador->user_dni); ?>"></td></tr>
           <tr><th><label>CIF (empresa):</label></th>
  <td>
    <select name="user_cif" required>
      <?php foreach ($empresas as $e): ?>
        <option value="<?php echo esc_attr($e->user_cif); ?>"
          <?php selected($editar_trabajador->user_cif, $e->user_cif); ?>>
          <?php echo esc_html($e->user_cif . ' — ' . ($e->razon_social ?: 'Sin razón social')); ?>
        </option>
      <?php endforeach; ?>
    </select>
  </td>
</tr>

            <tr><th><label>Contraseña:</label></th>
                <td><input type="text" name="user_pass" class="regular-text" placeholder="Dejar en blanco para no cambiarla"></td></tr>
        </table>
        <p><input type="submit" name="guardar_trabajador" class="button button-primary" value="Actualizar Trabajador"></p>
    </form>
<?php endif; ?>

<form method="get" style="margin-bottom: 20px;">
    <input type="hidden" name="page" value="control-horario">
    <input type="hidden" name="tab" value="trabajadores">
   <label>CIF:
  <select name="filtro_cif">
    <option value="">Todos</option>
    <?php foreach ($empresas as $e): ?>
      <option value="<?php echo esc_attr($e->user_cif); ?>" <?php selected($filtro_cif, $e->user_cif); ?>>
        <?php echo esc_html($e->user_cif . ' — [' . $e->id . '] ' . ($e->razon_social ?: 'Sin razón social')); ?>
      </option>
    <?php endforeach; ?>
  </select>
</label>

    <label>Estado:
        <select name="filtro_estado">
            <option value="">Todos</option>
            <option value="Activado" <?php selected($filtro_estado, 'Activado'); ?>>Activados</option>
            <option value="Desactivado" <?php selected($filtro_estado, 'Desactivado'); ?>>Desactivados</option>
        </select>
    </label>
    <input type="submit" class="button" value="Filtrar">
</form>

<h2 class="nav-tab-wrapper">
    <a href="?page=control-horario&tab=trabajadores&accion=nuevo" class="nav-tab <?php if ($_GET['accion'] === 'nuevo') echo 'nav-tab-active'; ?>">➕ Crear Trabajador</a>
    <a href="?page=control-horario&tab=trabajadores&accion=csv" class="nav-tab <?php if ($_GET['accion'] === 'csv') echo 'nav-tab-active'; ?>">📥 Cargar CSV</a>
</h2>

<?php if ($_GET['accion'] === 'nuevo'): ?>
    <form method="post">
        <table class="form-table">
            <tr><th><label>Nombre:</label></th><td><input type="text" name="nombre" required></td></tr>
            <tr><th><label>Email:</label></th><td><input type="email" name="email" required></td></tr>
            <tr><th><label>DNI:</label></th><td><input type="text" name="dni" pattern="[0-9]{6,8}" required></td></tr>
            <tr><th><label>CIF:</label></th><td>
                <select name="user_cif" required>
    <option value="">Selecciona un CIF</option>
    <?php foreach ($gestores as $empresa): ?>
        <option value="<?php echo esc_attr($empresa->user_cif); ?>">
            <?php echo esc_html($empresa->user_cif . ' — [' . $empresa->id . '] ' . ($empresa->razon_social ?: 'Sin razón social')); ?>
        </option>
    <?php endforeach; ?>
</select>

            </td></tr>
        </table>
        <p><input type="submit" name="crear_trabajador_manual" class="button button-primary" value="Crear Trabajador"></p>
    </form>
<?php elseif ($_GET['accion'] === 'csv'): ?>
    <form method="post" enctype="multipart/form-data">
        <table class="form-table">
            <tr><th><label>Archivo CSV:</label></th><td><input type="file" name="archivo_csv" accept=".csv" required></td></tr>
            <tr><th><label>CIF:</label></th><td>
                <select name="user_cif_csv" required>
    <option value="">Selecciona un CIF</option>
    <?php foreach ($gestores as $empresa): ?>
        <option value="<?php echo esc_attr($empresa->user_cif); ?>">
            <?php echo esc_html($empresa->user_cif . ' — [' . $empresa->id . '] ' . ($empresa->razon_social ?: 'Sin razón social')); ?>
        </option>
    <?php endforeach; ?>
</select>

            </td></tr>
        </table>
        <p>
    <input type="submit" class="button button-primary" value="Procesar CSV">
    <a href="https://docs.google.com/spreadsheets/d/1CiCHM66Rc3GWEvGus3sRyjZaZqQr94C8A2mkXC34WuY/edit?gid=0#gid=0"
       target="_blank" rel="noopener noreferrer" class="button button-secondary">
        📊 Ver plantilla CSV en Google Sheets
    </a>
</p>

    </form>
<?php endif; ?>

<table class="wp-list-table widefat fixed striped">
    <thead>
  <tr>
    <th>ID</th>
    <th>Nombre</th>
    <th>Email</th>
    <th>DNI</th>
    <th>CIF (usuario)</th>
    <th>CIF por ID</th>
    <th>ID Empresa</th>
    <th>Razón social</th>
    <th>Gamif. usuario</th>
    <th>Gamif. empresa</th>
    <th>Asociado</th>
    <th>Estado</th>
    <th>Acciones</th>
  </tr>
</thead>

    <tbody>
<?php foreach ($trabajadores as $t): ?>
  <tr>
    <td><?php echo esc_html($t->ID); ?></td>
<td><?php echo esc_html($t->display_name); ?></td>
    <td><?php echo esc_html($t->user_email); ?></td>
    <td><?php echo esc_html($t->user_dni); ?></td>
    <td><?php echo esc_html($t->user_cif); ?></td>
    <td><?php echo esc_html($t->empresa_cif_por_id ?: '—'); ?></td>
    <td><?php echo esc_html($t->empresa_id_ref ?: '—'); ?></td>
    <td><?php echo esc_html($t->empresa_razon_social ?: '—'); ?></td>
    <td>
  <?php if ((int)$t->user_gamificacion === 1): ?>
    <span style="color: green; font-weight: bold;">✔️ OK</span>
  <?php else: ?>
    <span style="color: red; font-weight: bold;">❌ NO</span>
  <?php endif; ?>
</td>

<td>
  <?php if ($t->empresa_gamificacion === 'activado'): ?>
    <span style="color: green; font-weight: bold;">✔️ OK</span>
  <?php else: ?>
    <span style="color: red; font-weight: bold;">❌ NO</span>
  <?php endif; ?>
</td>

    <td><?php echo $t->asociado_empresa ? 'Sí' : 'No'; ?></td>
    <td><?php echo esc_html($t->user_estado); ?></td>
    <td>
      <a href="?page=control-horario&tab=trabajadores&editar=<?php echo $t->ID; ?>" class="button">Editar</a>
      <a href="?page=control-horario&tab=trabajadores&toggle=<?php echo $t->ID; ?>" class="button">
        <?php echo ($t->user_estado === 'Activado') ? 'Desactivar' : 'Activar'; ?>
      </a>
      <a href="?page=control-horario&tab=trabajadores&reenviar=<?php echo $t->ID; ?>" class="button">Reenviar Contraseña</a>
    </td>
  </tr>
<?php endforeach; ?>
</tbody>

</table>
</div>

<?php error_log($email_body); ?>

