<?php
if (!current_user_can('manage_options')) {
    wp_die('No tienes permisos para acceder a esta sección.');
}

// Al enviar el formulario
if (isset($_POST['enviar_notificacion'])) {
    $asunto = sanitize_text_field($_POST['asunto']);
    $mensaje = wp_kses_post($_POST['mensaje']);
    $roles = isset($_POST['roles']) ? (array) $_POST['roles'] : [];
    $enviar_prueba = isset($_POST['prueba']);

    // Ruta de plantilla HTML
$template_path = plugin_dir_path(dirname(dirname(__FILE__))) . 'templates/notificacion.html';
    if (!file_exists($template_path)) {
        echo '<div class="notice notice-error"><p>No se encuentra la plantilla HTML.</p></div>';
        return;
    }

    $html = file_get_contents($template_path);
    $html_final = str_replace('${mensajeNotificacion}', nl2br($mensaje), $html);

    $destinatarios = [];

    if ($enviar_prueba) {
        $destinatarios[] = 'info@educasede.com';
    } elseif ($roles) {
        foreach ($roles as $rol) {
            $users = get_users(['role__in' => [$rol]]);
            foreach ($users as $user) {
                if (!in_array($user->user_email, $destinatarios)) {
                    $destinatarios[] = $user->user_email;
                }
            }
        }
    }

    $headers = ['Content-Type: text/html; charset=UTF-8', 'From: E-Digitiall <no-reply@educasede.com>'];

    $enviados = 0;
    foreach ($destinatarios as $email) {
        if (wp_mail($email, $asunto, $html_final, $headers)) {
            $enviados++;
        }
    }

    // Guardar registro
    $historial = get_option('notificaciones_enviadas', []);
    $historial[] = [
        'fecha' => current_time('Y-m-d H:i:s'),
        'asunto' => $asunto,
        'roles' => $roles,
        'prueba' => $enviar_prueba,
        'mensaje' => $mensaje,
        'enviados' => $enviados
    ];
    update_option('notificaciones_enviadas', $historial);

    echo '<div class="notice notice-success"><p>✅ Notificación enviada a ' . esc_html($enviados) . ' destinatario(s).</p></div>';
}
?>

<div class="wrap">
    <h1>📢 Enviar Novedad a Usuarios</h1>
    <form method="post" style="max-width: 700px;">
        <table class="form-table">
            <tr>
                <th><label for="asunto">Asunto:</label></th>
                <td><input type="text" name="asunto" id="asunto" class="regular-text" required></td>
            </tr>
            <tr>
                <th><label for="mensaje">Mensaje:</label></th>
                <td><textarea name="mensaje" id="mensaje" rows="8" class="large-text" required></textarea></td>
            </tr>
            <tr>
                <th><label for="roles">Enviar a roles:</label></th>
                <td>
                    <label><input type="checkbox" name="roles[]" value="Gestor"> Gestores</label><br>
                    <label><input type="checkbox" name="roles[]" value="Trabajador"> Trabajadores</label><br>
                    <label><input type="checkbox" name="roles[]" value="Inspector"> Inspectores</label>
                </td>
            </tr>
            <tr>
                <th><label for="prueba">Modo prueba:</label></th>
                <td><label><input type="checkbox" name="prueba" value="1"> Enviar solo a <code>info@educasede.com</code></label></td>
            </tr>
        </table>
        <p><button type="submit" name="enviar_notificacion" class="button button-primary">📨 Enviar Notificación</button></p>
    </form>

    <hr>
    <h2>📄 Historial de Envíos</h2>
    <table class="widefat fixed striped">
    <thead>
        <tr>
            <th>Fecha</th>
            <th>Asunto</th>
            <th>Roles</th>
            <th>Prueba</th>
            <th>Enviados</th>
            <th>Mensaje</th>
        </tr>
    </thead>
    <tbody>
        <?php
        $historial = array_reverse(get_option('notificaciones_enviadas', []));
        if ($historial) {
            foreach ($historial as $h) {
                echo '<tr>';
                echo '<td>' . esc_html($h['fecha']) . '</td>';
                echo '<td>' . esc_html($h['asunto']) . '</td>';
                echo '<td>' . implode(', ', array_map('esc_html', $h['roles'])) . '</td>';
                echo '<td>' . ($h['prueba'] ? '✅' : '—') . '</td>';
                echo '<td>' . esc_html($h['enviados']) . '</td>';
                echo '<td style="max-width: 300px;">' . wp_kses_post(nl2br($h['mensaje'])) . '</td>';
                echo '</tr>';
            }
        } else {
            echo '<tr><td colspan="6">No hay registros aún.</td></tr>';
        }
        ?>
    </tbody>
</table>

</div>
