<?php
// Evitar acceso directo
if (!defined('ABSPATH')) {
    exit;
}

// Función para eliminar un trabajador
function gt_eliminar_trabajadores() {
    if (!isset($_POST['user_id']) || !current_user_can('gestor')) {
        wp_die('No tienes permisos.');
    }

    $user_id = intval($_POST['user_id']);
    
    if (empty($user_id) || !get_userdata($user_id)) {
        wp_die('Error: El usuario no existe o el ID no es válido.');
    }

    // Eliminar el usuario
    $deleted = wp_delete_user($user_id);

    if (!$deleted) {
        wp_die('Error al eliminar el usuario.');
    }

    // Redirigir después de la eliminación
    wp_redirect($_SERVER['HTTP_REFERER']);
    exit;
}
add_action('admin_post_eliminar_trabajadores', 'gt_eliminar_trabajadores');
add_action('admin_post_nopriv_eliminar_trabajadores', 'gt_eliminar_trabajadores');