<?php
/**
 * Plugin Name: Control Horario - Integraciones Stripe (modular)
 * Description: Núcleo del plugin. Autocarga todos los módulos de la carpeta /includes (suscripción, webhooks, etc.).
 * Version: 1.0.0
 * Author: Control Horario
 */

if (!defined('ABSPATH')) exit;

// Constantes base del plugin
define('CH_STRIPE_WH_VERSION', '1.0.0');
define('CH_STRIPE_WH_PLUGIN_FILE', __FILE__);
define('CH_STRIPE_WH_PLUGIN_DIR', plugin_dir_path(__FILE__));
define('CH_STRIPE_WH_PLUGIN_URL', plugin_dir_url(__FILE__));

// Autocarga de todos los módulos en /includes/*.php
add_action('plugins_loaded', function () {
    $includes_dir = trailingslashit(CH_STRIPE_WH_PLUGIN_DIR . 'includes');

    if (is_dir($includes_dir)) {
        foreach (glob($includes_dir . '*.php') as $module_file) {
            // No generes salida, y que cada módulo se auto-instancie si procede
            require_once $module_file;
        }
    }
});
